/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.HashMap;
import java.util.Map;
import org.jboss.web.tomcat.service.session.ClusteredManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.OutgoingDistributableSessionDataImpl;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingSessionGranularitySessionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionBasedClusteredSession
extends ClusteredSession<OutgoingSessionGranularitySessionData> {
    static final long serialVersionUID = 3200976125245487256L;
    protected static final String info = "SessionBasedClusteredSession/1.0";

    public SessionBasedClusteredSession(ClusteredManager<OutgoingSessionGranularitySessionData> manager) {
        super(manager);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    protected OutgoingSessionGranularitySessionData getOutgoingSessionData() {
        boolean needFull = this.isFullReplicationNeeded();
        Map<String, Object> attrs = needFull || this.isSessionAttributeMapDirty() ? this.getSessionAttributeMap() : null;
        DistributableSessionMetadata metadata = needFull || this.isSessionMetadataDirty() ? this.getSessionMetadata() : null;
        Long timestamp = attrs != null || metadata != null || this.getMustReplicateTimestamp() ? Long.valueOf(this.getSessionTimestamp()) : null;
        return new OutgoingData(this.getRealId(), this.getVersion(), timestamp, metadata, attrs);
    }

    @Override
    protected Object removeAttributeInternal(String name, boolean localCall, boolean localOnly) {
        if (localCall) {
            this.sessionAttributesDirty();
        }
        return this.getAttributesInternal().remove(name);
    }

    @Override
    protected Object setAttributeInternal(String name, Object value) {
        this.sessionAttributesDirty();
        return this.getAttributesInternal().put(name, value);
    }

    private Map<String, Object> getSessionAttributeMap() {
        HashMap<String, Object> attrs = new HashMap<String, Object>(this.getAttributesInternal());
        this.removeExcludedAttributes(attrs);
        return attrs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutgoingData
    extends OutgoingDistributableSessionDataImpl
    implements OutgoingSessionGranularitySessionData {
        private final Map<String, Object> attributes;

        public OutgoingData(String realId, int version, Long timestamp, DistributableSessionMetadata metadata, Map<String, Object> attributes) {
            super(realId, version, timestamp, metadata);
            this.attributes = attributes;
        }

        public Map<String, Object> getSessionAttributes() {
            return this.attributes;
        }
    }
}

