/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import org.hibernate.Hibernate;
import org.hibernate.QueryException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.LiteralNode;
import org.hibernate.type.BooleanType;
import org.hibernate.type.Type;

public class BooleanLiteralNode
extends LiteralNode
implements ExpectedTypeAwareNode {
    private Type expectedType;

    @Override
    public Type getDataType() {
        return this.expectedType == null ? Hibernate.BOOLEAN : this.expectedType;
    }

    public BooleanType getTypeInternal() {
        return (BooleanType)this.getDataType();
    }

    public Boolean getValue() {
        return this.getType() == 49 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setExpectedType(Type expectedType) {
        this.expectedType = expectedType;
    }

    @Override
    public Type getExpectedType() {
        return this.expectedType;
    }

    @Override
    public String getRenderText(SessionFactoryImplementor sessionFactory) {
        try {
            return this.getTypeInternal().objectToSQLString(this.getValue(), sessionFactory.getDialect());
        }
        catch (Throwable t) {
            throw new QueryException("Unable to render boolean literal value", t);
        }
    }
}

