/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.MutableType;
import org.hibernate.type.VersionType;
import org.hibernate.util.CalendarComparator;

public class CalendarType
extends MutableType
implements VersionType {
    @Override
    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        Timestamp ts = rs.getTimestamp(name);
        if (ts != null) {
            GregorianCalendar cal = new GregorianCalendar();
            if (Environment.jvmHasTimestampBug()) {
                cal.setTime(new Date(ts.getTime() + (long)(ts.getNanos() / 1000000)));
            } else {
                cal.setTime(ts);
            }
            return cal;
        }
        return null;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        Calendar cal = (Calendar)value;
        st.setTimestamp(index, new Timestamp(cal.getTime().getTime()), cal);
    }

    @Override
    public int sqlType() {
        return 93;
    }

    @Override
    public String toString(Object value) throws HibernateException {
        return Hibernate.TIMESTAMP.toString(((Calendar)value).getTime());
    }

    @Override
    public Object fromStringValue(String xml) throws HibernateException {
        GregorianCalendar result = new GregorianCalendar();
        result.setTime((Date)Hibernate.TIMESTAMP.fromStringValue(xml));
        return result;
    }

    @Override
    public Object deepCopyNotNull(Object value) throws HibernateException {
        return ((Calendar)value).clone();
    }

    @Override
    public Class getReturnedClass() {
        return Calendar.class;
    }

    @Override
    public int compare(Object x, Object y, EntityMode entityMode) {
        return CalendarComparator.INSTANCE.compare(x, y);
    }

    @Override
    public boolean isEqual(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Calendar calendar1 = (Calendar)x;
        Calendar calendar2 = (Calendar)y;
        return calendar1.get(14) == calendar2.get(14) && calendar1.get(13) == calendar2.get(13) && calendar1.get(12) == calendar2.get(12) && calendar1.get(11) == calendar2.get(11) && calendar1.get(5) == calendar2.get(5) && calendar1.get(2) == calendar2.get(2) && calendar1.get(1) == calendar2.get(1);
    }

    @Override
    public int getHashCode(Object x, EntityMode entityMode) {
        Calendar calendar = (Calendar)x;
        int hashCode = 1;
        hashCode = 31 * hashCode + calendar.get(14);
        hashCode = 31 * hashCode + calendar.get(13);
        hashCode = 31 * hashCode + calendar.get(12);
        hashCode = 31 * hashCode + calendar.get(11);
        hashCode = 31 * hashCode + calendar.get(5);
        hashCode = 31 * hashCode + calendar.get(2);
        hashCode = 31 * hashCode + calendar.get(1);
        return hashCode;
    }

    @Override
    public String getName() {
        return "calendar";
    }

    @Override
    public Object next(Object current, SessionImplementor session) {
        return this.seed(session);
    }

    @Override
    public Object seed(SessionImplementor session) {
        return Calendar.getInstance();
    }

    @Override
    public Comparator getComparator() {
        return CalendarComparator.INSTANCE;
    }
}

