/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.util;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.core.Manager;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.util.Strings;
import org.rhq.core.gui.util.FacesExpressionUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.exception.WrappedRemotingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacesContextUtility {
    public static String getOptionalRequestParameter(String paramName) {
        return FacesContextUtility.getOptionalRequestParameter(paramName, String.class, null);
    }

    public static <T> T getOptionalRequestParameter(String paramName, Class<T> type) {
        return FacesContextUtility.getOptionalRequestParameter(paramName, type, null);
    }

    public static String getOptionalRequestParameter(String paramName, String defaultValue) {
        return FacesContextUtility.getOptionalRequestParameter(paramName, String.class, defaultValue);
    }

    public static <T> T getOptionalRequestParameter(String paramName, Class<T> type, T defaultValue) {
        Object result;
        FacesContext facesContext = FacesContextUtility.getFacesContext();
        String paramValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(paramName);
        if (paramValue != null) {
            if (type == String.class) {
                result = paramValue;
            } else {
                try {
                    if (type == Boolean.class && (paramValue.equalsIgnoreCase("on") || paramValue.equalsIgnoreCase("yes"))) {
                        paramValue = "true";
                    }
                    Method m = type.getMethod("valueOf", String.class);
                    result = m.invoke(null, paramValue);
                }
                catch (Exception e) {
                    result = null;
                }
            }
        } else {
            result = defaultValue;
        }
        return result;
    }

    public static String getRequiredRequestParameter(String paramName) {
        return FacesContextUtility.getRequiredRequestParameter(paramName, String.class);
    }

    public static <T> T getRequiredRequestParameter(String paramName, Class<T> type) {
        T paramValue = FacesContextUtility.getOptionalRequestParameter(paramName, type, null);
        if (paramValue == null) {
            throw new IllegalStateException("Required request parameter '" + paramName + "' is missing.");
        }
        return paramValue;
    }

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = (HttpServletRequest)FacesContextUtility.getFacesContext().getExternalContext().getRequest();
        return request;
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = (HttpServletResponse)FacesContextUtility.getFacesContext().getExternalContext().getResponse();
        return response;
    }

    public static void addMessage(FacesMessage.Severity severity, String summary) {
        String detail = "";
        FacesContextUtility.addMessage(severity, summary, detail);
    }

    public static void addMessage(FacesMessage.Severity severity, String summary, Throwable t) {
        String detail = FacesContextUtility.createDetailMessage(t);
        FacesContextUtility.addMessage(severity, summary, detail);
    }

    public static void addMessage(FacesMessage.Severity severity, String summary, String detail) {
        if (Manager.instance().isReallyLongRunningConversation()) {
            String detailToUse = Strings.isEmpty((String)detail) ? "\u00a0" : detail;
            FacesMessages.instance().add(FacesContextUtility.toSeverity(severity), null, null, summary, detailToUse, new Object[0]);
        } else {
            FacesContextUtility.getFacesContext().addMessage(null, new FacesMessage(severity, summary, detail != null ? detail : ""));
        }
    }

    public static FacesContext getFacesContext() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext;
    }

    public static String getViewId() {
        return FacesContextUtility.getFacesContext().getViewRoot().getViewId();
    }

    public static <T> T getBean(Class<T> type) {
        String fqn = type.getName();
        String clazz = fqn.substring(fqn.lastIndexOf(46) + 1);
        Object result = FacesContextUtility.getRequest().getAttribute(clazz);
        if (result == null) {
            result = FacesContextUtility.getRequest().getSession().getAttribute(clazz);
        }
        if (result == null) {
            try {
                result = type.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            FacesContextUtility.setBean(result);
        }
        return (T)result;
    }

    public static <T> void removeSessionScopedBean(Class<T> type) {
        String fqn = type.getName();
        String clazz = fqn.substring(fqn.lastIndexOf(46) + 1);
        FacesContextUtility.getRequest().getSession().removeAttribute(clazz);
    }

    public static <T> T getManagedBean(Class<T> type) {
        ValueExpression managedBeanValueExpression = FacesContextUtility.getValueExpressionForManagedBean(type);
        T managedBean = FacesExpressionUtility.getValue(managedBeanValueExpression, type);
        return managedBean;
    }

    public static void setManagedBean(Object managedBean) {
        ValueExpression managedBeanValueExpression = FacesContextUtility.getValueExpressionForManagedBean(managedBean.getClass());
        FacesExpressionUtility.setValue(managedBeanValueExpression, managedBean);
    }

    private static <T> ValueExpression getValueExpressionForManagedBean(Class<T> type) {
        String managedBeanName = type.getSimpleName();
        String managedBeanExpressionString = "#{" + managedBeanName + "}";
        ValueExpression managedBeanValueExpression = FacesExpressionUtility.createValueExpression(managedBeanExpressionString, type);
        return managedBeanValueExpression;
    }

    public static void setBean(Object object) {
        HttpServletRequest request = FacesContextUtility.getRequest();
        request.setAttribute(object.getClass().getSimpleName(), object);
    }

    public static void clearMessages() {
        Iterator messages = FacesContext.getCurrentInstance().getMessages();
        while (messages.hasNext()) {
            messages.next();
            messages.remove();
        }
    }

    public static void clearMessages(String clientId) {
        Iterator messages = FacesContext.getCurrentInstance().getMessages(clientId);
        while (messages.hasNext()) {
            messages.next();
            messages.remove();
        }
    }

    private static String createDetailMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        StringBuilder detailMessage = new StringBuilder("Cause: ");
        if (t.getCause() instanceof WrappedRemotingException) {
            WrappedRemotingException wre = (WrappedRemotingException)t.getCause();
            detailMessage.append(wre.getActualException().getAllMessages());
        } else {
            detailMessage.append(ThrowableUtil.getAllMessages((Throwable)t));
        }
        return detailMessage.toString();
    }

    private static StatusMessage.Severity toSeverity(FacesMessage.Severity severity) {
        if (FacesMessage.SEVERITY_ERROR.equals(severity)) {
            return StatusMessage.Severity.ERROR;
        }
        if (FacesMessage.SEVERITY_FATAL.equals(severity)) {
            return StatusMessage.Severity.FATAL;
        }
        if (FacesMessage.SEVERITY_INFO.equals(severity)) {
            return StatusMessage.Severity.INFO;
        }
        if (FacesMessage.SEVERITY_WARN.equals(severity)) {
            return StatusMessage.Severity.WARN;
        }
        return null;
    }
}

