/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.util;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtility {
    private static char CHAR_SPACE = (char)32;

    public static <T> String getListAsDelimitedString(List<T> items) {
        return StringUtility.getListAsDelimitedString(items, ',');
    }

    public static <T> String getListAsDelimitedString(List<T> items, char delimiter) {
        if (items.size() < 1) {
            return "";
        }
        StringBuilder results = new StringBuilder();
        results.append(items.get(0).toString());
        for (int i = 1; i < items.size(); ++i) {
            results.append(delimiter).append(CHAR_SPACE).append(items.get(i).toString());
        }
        return results.toString();
    }

    public static Integer[] getIntegerArray(List<String> list) {
        if (list == null) {
            return new Integer[0];
        }
        Integer[] results = new Integer[list.size()];
        int i = 0;
        for (String item : list) {
            results[i++] = Integer.valueOf(item);
        }
        return results;
    }

    public static Integer[] getIntegerArray(String[] list) {
        if (list == null) {
            return new Integer[0];
        }
        Integer[] results = new Integer[list.length];
        int i = 0;
        for (String item : list) {
            results[i++] = Integer.valueOf(item);
        }
        return results;
    }

    public static int[] getIntArray(String[] list) {
        if (list == null) {
            return new int[0];
        }
        int[] results = new int[list.length];
        int i = 0;
        for (String item : list) {
            results[i++] = Integer.valueOf(item);
        }
        return results;
    }

    public static int[] getIntArray(List<String> list) {
        if (list == null) {
            return new int[0];
        }
        int[] results = new int[list.size()];
        int i = 0;
        for (String item : list) {
            results[i++] = Integer.valueOf(item);
        }
        return results;
    }
}

