/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.OutputStream;
import java.util.EnumMap;
import java.util.logging.Formatter;
import org.jboss.logmanager.formatters.Formatters;
import org.jboss.logmanager.handlers.OutputStreamHandler;
import org.jboss.logmanager.handlers.UncloseableOutputStream;

public class ConsoleHandler
extends OutputStreamHandler {
    private static final OutputStream out = System.out;
    private static final OutputStream err = System.err;
    private static final EnumMap<Target, OutputStream> targets;

    public ConsoleHandler() {
        this(Formatters.nullFormatter());
    }

    public ConsoleHandler(Formatter formatter) {
        this(Target.SYSTEM_OUT, formatter);
    }

    public ConsoleHandler(Target target) {
        this(target, Formatters.nullFormatter());
    }

    public ConsoleHandler(Target target, Formatter formatter) {
        super(ConsoleHandler.wrap(targets.get((Object)target)), formatter);
    }

    public void setTarget(Target target) {
        this.setOutputStream(targets.get((Object)target));
    }

    private static OutputStream wrap(OutputStream outputStream) {
        return outputStream == null ? null : (outputStream instanceof UncloseableOutputStream ? outputStream : new UncloseableOutputStream(outputStream));
    }

    public void setOutputStream(OutputStream outputStream) {
        super.setOutputStream(ConsoleHandler.wrap(outputStream));
    }

    static {
        EnumMap<Target, OutputStream> map = new EnumMap<Target, OutputStream>(Target.class);
        map.put(Target.SYSTEM_ERR, err);
        map.put(Target.SYSTEM_OUT, out);
        targets = map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {
        SYSTEM_OUT,
        SYSTEM_ERR;

    }
}

