/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.inventory.InventoryEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingInventoryEventListener
implements InventoryEventListener {
    private final Log log = LogFactory.getLog(this.getClass());

    public void resourcesAdded(Set<Resource> resources) {
        this.log.trace((Object)("The following Resources have been added: " + LoggingInventoryEventListener.toString(resources)));
    }

    public void resourcesRemoved(Set<Resource> resources) {
        this.log.debug((Object)("The following Resources have been removed: " + LoggingInventoryEventListener.toString(resources)));
    }

    public void resourceActivated(Resource resource) {
        HashSet<Resource> resources = new HashSet<Resource>();
        resources.add(resource);
        this.log.trace((Object)("The following Resource has been activated: " + LoggingInventoryEventListener.toString(resources)));
    }

    public void resourceDeactivated(Resource resource) {
        HashSet<Resource> resources = new HashSet<Resource>();
        resources.add(resource);
        this.log.trace((Object)("The following Resource has been deactivated: " + LoggingInventoryEventListener.toString(resources)));
    }

    private static String toString(Set<Resource> resources) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Resource resource : resources) {
            stringBuilder.append("Resource[").append(resource.getId()).append("]: ").append(resource.getName()).append(", ");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }
}

