/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.benchmark;

import gnu.trove.benchmark.Reporter;
import gnu.trove.benchmark.Result;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

class XMLReporter
implements Reporter {
    PrintWriter out;

    XMLReporter() {
        this.out = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
    }

    XMLReporter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void report(Result result) {
        this.out.println("<result>");
        this.out.print("<desc>");
        this.out.print(result.getDescription());
        this.out.println("</desc>");
        this.out.print("<iterations>");
        this.out.print(result.getIterations());
        this.out.println("</iterations>");
        this.out.print("<theirTotal>");
        this.out.print(result.getTheirs());
        this.out.println("</theirTotal>");
        this.out.print("<theirAvg>");
        this.out.print(result.getTheirAvg());
        this.out.println("</theirAvg>");
        this.out.print("<ourTotal>");
        this.out.print(result.getOurs());
        this.out.println("</ourTotal>");
        this.out.print("<ourAvg>");
        this.out.print(result.getOurAvg());
        this.out.println("</ourAvg>");
        this.out.println("</result>");
    }

    @Override
    public void start() {
        this.out.println("<?xml version=\"1.0\" encoding=\"ASCII\" ?>");
        this.out.println("<benchmark>");
        this.out.print("<env>");
        for (int i = 0; i < ENV_PROPS.length; ++i) {
            String key = ENV_PROPS[i];
            this.out.print(System.getProperty(key));
            this.out.print(" ");
        }
        this.out.println("</env>");
    }

    @Override
    public void finish() {
        this.out.println("</benchmark>");
    }
}

