/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbosscache3;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbosscache3.JBossCacheComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheDiscoveryComponent
implements ResourceDiscoveryComponent<ProfileServiceComponent> {
    private String REGEX = "(,|:)jmx-resource=[^,]*(,|\\z)";
    private static String[] RESOURCE_NAME_KEY_PROPS = new String[]{"cluster", "config"};
    private static final String DEFAULT_RESOURCE_DESCRIPTION = "JBoss Cache";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ProfileServiceComponent> context) throws InvalidPluginConfigurationException, Exception {
        ProfileServiceComponent parentComponent = (ProfileServiceComponent)context.getParentResourceComponent();
        Configuration defaultPluginConfig = context.getDefaultPluginConfiguration();
        EmsConnection connection = parentComponent.getEmsConnection();
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        Pattern pattern = Pattern.compile(this.REGEX);
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(defaultPluginConfig.getSimple(JBossCacheComponent.CACHE_SEARCH_STRING).getStringValue());
        List cacheBeans = connection.queryBeans(queryUtility.getTranslatedQuery());
        HashSet<String> beanNames = new HashSet<String>();
        for (EmsBean bean : cacheBeans) {
            String beanName = bean.getBeanName().toString();
            Matcher m = pattern.matcher(beanName);
            if (!m.find() || beanNames.contains(beanName = m.replaceFirst(m.group(2).equals(",") ? m.group(1) : ""))) continue;
            beanNames.add(beanName);
        }
        for (String beanName : beanNames) {
            Configuration pluginConfig = context.getDefaultPluginConfiguration();
            pluginConfig.put((Property)new PropertySimple(JBossCacheComponent.CACHE_SEARCH_STRING, (Object)beanName));
            String resourceName = beanName;
            ObjectName objName = new ObjectName(beanName);
            for (String objectName : RESOURCE_NAME_KEY_PROPS) {
                if (objName.getKeyProperty(objectName) == null) continue;
                resourceName = objName.getKeyProperty(objectName);
            }
            ResourceType resourceType = context.getResourceType();
            resources.add(new DiscoveredResourceDetails(resourceType, beanName, resourceName, null, DEFAULT_RESOURCE_DESCRIPTION, pluginConfig, null));
        }
        return resources;
    }
}

