/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.timestamp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.timestamp.TimestampDiscrepancy;
import org.jboss.ha.timestamp.TimestampDiscrepancyObserver;
import org.jboss.ha.timestamp.TimestampDiscrepancyService;
import org.jboss.logging.Logger;

public class TimestampDiscrepancyValidationService
implements TimestampDiscrepancyObserver {
    private static final Object NULL = new Object();
    private static final Logger log = Logger.getLogger(TimestampDiscrepancyValidationService.class);
    public static final long DEFAULT_MAX_DISCREPANCY = 60000L;
    private TimestampDiscrepancyService service;
    private long maxDiscrepancy = 60000L;
    private final Map<ClusterNode, Object> loggedNodes = new ConcurrentHashMap<ClusterNode, Object>();
    private boolean useErrorLogging;

    public TimestampDiscrepancyService getTimestampDiscrepancyService() {
        return this.service;
    }

    public void setTimestampDiscrepancyService(TimestampDiscrepancyService service) {
        this.service = service;
    }

    public long getMaxDiscrepancy() {
        return this.maxDiscrepancy;
    }

    public void setMaxDiscrepancy(long maxDiscrepancy) {
        this.maxDiscrepancy = maxDiscrepancy;
    }

    public boolean getUseErrorLogging() {
        return this.useErrorLogging;
    }

    public void setUseErrorLogging(boolean useErrorLogging) {
        this.useErrorLogging = useErrorLogging;
    }

    public void start() {
        if (this.service == null) {
            throw new IllegalStateException("A TimestampDiscrepancyService must be injected");
        }
        Map<ClusterNode, TimestampDiscrepancy> map = this.service.getTimestampDiscrepancies(true);
        for (Map.Entry<ClusterNode, TimestampDiscrepancy> entry : map.entrySet()) {
            this.timestampDiscrepancyChanged(entry.getKey(), entry.getValue());
        }
    }

    public void stop() {
        this.loggedNodes.clear();
    }

    public boolean canRemoveDeadEntry(ClusterNode dead, long lastChecked) {
        return true;
    }

    public void timestampDiscrepancyChanged(ClusterNode node, TimestampDiscrepancy discrepancy) {
        long discrep;
        if (this.service.isServerActive(node) && (discrep = Math.max(Math.abs(discrepancy.getMinDiscrepancy()), Math.abs(discrepancy.getMaxDiscrepancy()))) > this.maxDiscrepancy && this.loggedNodes.put(node, NULL) == null) {
            String msg = "Possible excessive system clock discrepancy between this node and " + node + " -- potential discrepancy of" + discrep + " ms exceeds the configured limit of " + this.maxDiscrepancy + " ms";
            if (this.useErrorLogging) {
                log.error((Object)msg);
            } else {
                log.warn((Object)msg);
            }
        }
    }
}

