/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.msv;

import com.ctc.wstx.api.ValidatorConfig;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.msv.RelaxNGSchema;
import com.ctc.wstx.util.URLUtil;
import com.sun.msv.grammar.trex.TREXGrammar;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.reader.util.IgnoreController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class RelaxNGSchemaFactory
extends XMLValidationSchemaFactory {
    protected final SAXParserFactory mSaxFactory;
    protected final ValidatorConfig mConfig;
    protected final GrammarReaderController mDummyController = new IgnoreController();

    public RelaxNGSchemaFactory() {
        this.mSaxFactory = SAXParserFactory.newInstance();
        this.mSaxFactory.setNamespaceAware(true);
        this.mConfig = ValidatorConfig.createDefaults();
    }

    @Override
    public boolean isPropertySupported(String propName) {
        return this.mConfig.isPropertySupported(propName);
    }

    @Override
    public boolean setProperty(String propName, Object value) {
        return this.mConfig.setProperty(propName, value);
    }

    @Override
    public Object getProperty(String propName) {
        return this.mConfig.getProperty(propName);
    }

    @Override
    public XMLValidationSchema createSchema(InputStream in, String encoding, String publicId, String systemId) throws XMLStreamException {
        InputSource src = new InputSource(in);
        src.setEncoding(encoding);
        src.setPublicId(publicId);
        src.setSystemId(systemId);
        return this.loadSchema(src, systemId);
    }

    @Override
    public XMLValidationSchema createSchema(Reader r, String publicId, String systemId) throws XMLStreamException {
        InputSource src = new InputSource(r);
        src.setPublicId(publicId);
        src.setSystemId(systemId);
        return this.loadSchema(src, systemId);
    }

    @Override
    public XMLValidationSchema createSchema(URL url) throws XMLStreamException {
        try {
            InputStream in = URLUtil.optimizedStreamFromURL(url);
            InputSource src = new InputSource(in);
            src.setSystemId(url.toExternalForm());
            return this.loadSchema(src, url);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    @Override
    public XMLValidationSchema createSchema(File f) throws XMLStreamException {
        try {
            return this.createSchema(f.toURL());
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    protected XMLValidationSchema loadSchema(InputSource src, Object sysRef) throws XMLStreamException {
        MyGrammarController ctrl = new MyGrammarController();
        TREXGrammar grammar = RELAXNGReader.parse((InputSource)src, (SAXParserFactory)this.mSaxFactory, (GrammarReaderController)ctrl);
        if (grammar == null) {
            String msg = "Failed to load RelaxNG from '" + sysRef + "'";
            String emsg = ctrl.mErrorMsg;
            if (emsg != null) {
                msg = msg + ": " + emsg;
            }
            throw new XMLStreamException(msg);
        }
        return new RelaxNGSchema(grammar);
    }

    static final class MyGrammarController
    extends IgnoreController {
        public String mErrorMsg = null;

        public void error(Locator[] locs, String msg, Exception nestedException) {
            this.mErrorMsg = this.mErrorMsg == null ? msg : this.mErrorMsg + "; " + msg;
        }
    }
}

