/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.jboss.seam.ui.converter.PrioritizableConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterChain
implements Converter,
StateHolder {
    public static final String CONTINUE = "org.jboss.seam.ui.ConverterChain.continue";
    public static final int CHAIN_END = Integer.MAX_VALUE;
    public static final int CHAIN_START = 0;
    private List<PrioritizableConverter> converters = new ArrayList<PrioritizableConverter>();
    private boolean dirty;
    private boolean _transient;

    public ConverterChain() {
    }

    public ConverterChain(UIComponent component) {
        this();
        ValueHolder valueHolder;
        if (component instanceof ValueHolder && !((valueHolder = (ValueHolder)component).getConverter() instanceof ConverterChain)) {
            ValueExpression converterValueExpression = component.getValueExpression("converter");
            if (converterValueExpression != null) {
                this.addConverterToChain(converterValueExpression);
            } else if (valueHolder.getConverter() != null) {
                this.addConverterToChain(valueHolder.getConverter());
            } else {
                Converter converter;
                Class type;
                ValueExpression valueExpression = component.getValueExpression("value");
                FacesContext facesContext = FacesContext.getCurrentInstance();
                if (valueExpression != null && (type = valueExpression.getType(facesContext.getELContext())) != null && (converter = facesContext.getApplication().createConverter(type)) != null) {
                    this.addConverterToChain(converter);
                }
            }
            valueHolder.setConverter((Converter)this);
        }
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        Object output = value;
        for (PrioritizableConverter converter : this.getConverters()) {
            Object result = converter.getAsObject(context, component, value);
            if (CONTINUE.equals(result)) continue;
            output = result;
            break;
        }
        return output;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        String output = value == null ? null : value.toString();
        for (PrioritizableConverter converter : this.getConverters()) {
            String result = converter.getAsString(context, component, value);
            if (CONTINUE.equals(result)) continue;
            output = result;
            break;
        }
        return output;
    }

    public boolean addConverterToChain(Converter c) {
        return this.addConverterToChain(c, Integer.MAX_VALUE);
    }

    public boolean addConverterToChain(ValueExpression c) {
        return this.addConverterToChain(c, Integer.MAX_VALUE);
    }

    public boolean addConverterToChain(Converter c, int priority) {
        if (c != null) {
            this.dirty = true;
            return this.converters.add(new PrioritizableConverter(c, priority));
        }
        return false;
    }

    public boolean addConverterToChain(ValueExpression c, int priority) {
        if (c != null) {
            this.dirty = true;
            return this.converters.add(new PrioritizableConverter(c, priority));
        }
        return false;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.converters = (List)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[0]);
        this.dirty = true;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, this.converters)};
        return values;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    private List<PrioritizableConverter> getConverters() {
        if (this.dirty) {
            Collections.sort(this.converters);
        }
        return this.converters;
    }

    public boolean containsConverterType(Converter converter) {
        for (PrioritizableConverter c : this.converters) {
            if (!c.getClass().equals(converter.getClass())) continue;
            return true;
        }
        return false;
    }
}

