/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;

public class MockRequestDispatcher
implements RequestDispatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String url;

    public MockRequestDispatcher(String url) {
        this.url = url;
    }

    public void forward(ServletRequest request, ServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        this.getMockHttpServletResponse(response).setForwardedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MockRequestDispatcher: forwarding to URL [" + this.url + "]"));
        }
    }

    public void include(ServletRequest request, ServletResponse response) {
        this.getMockHttpServletResponse(response).setIncludedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MockRequestDispatcher: including URL [" + this.url + "]"));
        }
    }

    protected EnhancedMockHttpServletResponse getMockHttpServletResponse(ServletResponse response) {
        if (response instanceof EnhancedMockHttpServletResponse) {
            return (EnhancedMockHttpServletResponse)response;
        }
        if (response instanceof HttpServletResponseWrapper) {
            return this.getMockHttpServletResponse(((HttpServletResponseWrapper)response).getResponse());
        }
        throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
    }
}

