/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.web.tomcat.service.StatusTransformer;

public class StatusServlet
extends HttpServlet
implements NotificationListener {
    private int debug = 0;
    protected MBeanServer mBeanServer = null;
    protected Vector protocolHandlers = new Vector();
    protected Vector threadPools = new Vector();
    protected Vector requestProcessors = new Vector();
    protected Vector globalRequestProcessors = new Vector();
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.manager");
    private static final String HTML_HEADER = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title>Tomcat Status</title><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\" /><link rel=\"StyleSheet\" href=\"css/jboss.css\" type=\"text/css\"/></head><body><!-- header begin --><a href=\"http://www.jboss.org\"><img src=\"images/logo.gif\" alt=\"JBoss\" id=\"logo\" width=\"226\" height=\"105\" /></a><div id=\"header\">&nbsp;</div><div id=\"navigation_bar\"></div><!-- header end -->";
    private static final String HTML_FOOTER = "<!-- footer begin --><div id=\"footer\"><div id=\"credits\">JBoss&trade; Application Server</div><div id=\"footer_bar\">&nbsp;</div></div><!-- footer end --></body></html>";

    public void init() throws ServletException {
        this.mBeanServer = Registry.getServer();
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            String onStr = "*:type=ProtocolHandler,*";
            ObjectName objectName = new ObjectName(onStr);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.protocolHandlers.addElement(oi.getObjectName());
            }
            onStr = "*:type=ThreadPool,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.threadPools.addElement(oi.getObjectName());
            }
            onStr = "*:type=GlobalRequestProcessor,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.globalRequestProcessors.addElement(oi.getObjectName());
            }
            onStr = "*:type=RequestProcessor,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.requestProcessors.addElement(oi.getObjectName());
            }
            onStr = "JMImplementation:type=MBeanServerDelegate";
            objectName = new ObjectName(onStr);
            this.mBeanServer.addNotificationListener(objectName, this, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int mode = 0;
        if ("true".equals(request.getParameter("XML"))) {
            mode = 1;
        }
        StatusTransformer.setContentType(response, mode);
        PrintWriter writer = response.getWriter();
        boolean completeStatus = false;
        if ("true".equals(request.getParameter("full"))) {
            completeStatus = true;
        }
        if (mode == 0) {
            writer.print(HTML_HEADER);
        } else if (mode == 1) {
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            writer.write("<?xml-stylesheet type=\"text/xsl\" href=\"/manager/xform.xsl\" ?>");
            writer.write("<status>");
        }
        try {
            StatusTransformer.writeVMState(writer, mode);
            Enumeration i = this.threadPools.elements();
            while (i.hasMoreElements()) {
                ObjectName objectName = (ObjectName)i.nextElement();
                String name = objectName.getKeyProperty("name");
                StatusTransformer.writeConnectorState(writer, objectName, name, this.mBeanServer, this.globalRequestProcessors, this.requestProcessors, mode);
            }
            if (completeStatus) {
                StatusTransformer.writeDetailedState(writer, this.mBeanServer, mode);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (mode == 0) {
            writer.print(HTML_FOOTER);
        } else if (mode == 1) {
            writer.write("</status>");
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (notification.getType().equals("JMX.mbean.registered")) {
                String type = objectName.getKeyProperty("type");
                if (type != null) {
                    if (type.equals("ProtocolHandler")) {
                        this.protocolHandlers.addElement(objectName);
                    } else if (type.equals("ThreadPool")) {
                        this.threadPools.addElement(objectName);
                    } else if (type.equals("GlobalRequestProcessor")) {
                        this.globalRequestProcessors.addElement(objectName);
                    } else if (type.equals("RequestProcessor")) {
                        this.requestProcessors.addElement(objectName);
                    }
                }
            } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                String j2eeType;
                String type = objectName.getKeyProperty("type");
                if (type != null) {
                    if (type.equals("ProtocolHandler")) {
                        this.protocolHandlers.removeElement(objectName);
                    } else if (type.equals("ThreadPool")) {
                        this.threadPools.removeElement(objectName);
                    } else if (type.equals("GlobalRequestProcessor")) {
                        this.globalRequestProcessors.removeElement(objectName);
                    } else if (type.equals("RequestProcessor")) {
                        this.requestProcessors.removeElement(objectName);
                    }
                }
                if ((j2eeType = objectName.getKeyProperty("j2eeType")) != null) {
                    // empty if block
                }
            }
        }
    }
}

