/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.util.Config;

class ServiceNameTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$ServiceNameTable == null ? (class$org$apache$juddi$datastore$jdbc$ServiceNameTable = ServiceNameTable.class$("org.apache.juddi.datastore.jdbc.ServiceNameTable")) : class$org$apache$juddi$datastore$jdbc$ServiceNameTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static String tablePrefix = "";
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$ServiceNameTable;

    ServiceNameTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String serviceKey, Vector nameList, Connection connection) throws SQLException {
        if (nameList == null || nameList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, serviceKey.toString());
            int listSize = nameList.size();
            for (int nameID = 0; nameID < listSize; ++nameID) {
                Name name = (Name)nameList.elementAt(nameID);
                statement.setInt(2, nameID);
                statement.setString(3, name.getLanguageCode());
                statement.setString(4, name.getValue());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("insert into " + tablePrefix + "SERVICE_NAME table:\n\n\t" + insertSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n\t SERVICE_NAME_ID=" + nameID + "\n\t LANG_CODE=" + name.getLanguageCode() + "\n\t NAME=" + name.getValue() + "\n"));
                }
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String serviceKey, Connection connection) throws SQLException {
        Vector<Name> nameList = new Vector<Name>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, serviceKey.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("select from SERVICE_NAME table:\n\n\t" + selectSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Name name = new Name();
                name.setLanguageCode(resultSet.getString(1));
                name.setValue(resultSet.getString(2));
                nameList.add(name);
            }
            Vector<Name> vector = nameList;
            return vector;
        }
        finally {
            try {
                statement.close();
                resultSet.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String serviceKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, serviceKey.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("delete from SERVICE_NAME table:\n\n\t" + deleteSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            }
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tablePrefix = Config.getStringProperty("juddi.tablePrefix", "");
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO ").append(tablePrefix).append("SERVICE_NAME (");
        sql.append("SERVICE_KEY,");
        sql.append("SERVICE_NAME_ID,");
        sql.append("LANG_CODE,");
        sql.append("NAME) ");
        sql.append("VALUES (?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("LANG_CODE,");
        sql.append("NAME, ");
        sql.append("SERVICE_NAME_ID ");
        sql.append("FROM ").append(tablePrefix).append("SERVICE_NAME ");
        sql.append("WHERE SERVICE_KEY=? ");
        sql.append("ORDER BY SERVICE_NAME_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM ").append(tablePrefix).append("SERVICE_NAME ");
        sql.append("WHERE SERVICE_KEY=?");
        deleteSQL = sql.toString();
    }
}

