/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.util.Config;

class TModelTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$TModelTable == null ? (class$org$apache$juddi$datastore$jdbc$TModelTable = TModelTable.class$("org.apache.juddi.datastore.jdbc.TModelTable")) : class$org$apache$juddi$datastore$jdbc$TModelTable));
    static String insertSQL = null;
    static String deleteSQL = null;
    static String updateSQL = null;
    static String selectSQL = null;
    static String selectByPublisherSQL = null;
    static String verifyOwnershipSQL = null;
    static String tablePrefix = "";
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$TModelTable;

    TModelTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(TModel tModel, String publisherID, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
        String overviewURL = null;
        if (tModel.getOverviewDoc() != null && tModel.getOverviewDoc().getOverviewURL() != null) {
            overviewURL = tModel.getOverviewDoc().getOverviewURL().getValue();
        }
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, tModel.getTModelKey().toString());
            statement.setString(2, tModel.getAuthorizedName());
            statement.setString(3, publisherID);
            statement.setString(4, tModel.getOperator());
            statement.setString(5, tModel.getName().getValue());
            statement.setString(6, tModel.getName().getLanguageCode());
            statement.setString(7, overviewURL);
            statement.setTimestamp(8, timeStamp);
            if (log.isDebugEnabled()) {
                log.debug((Object)(insertSQL + "\n\t TMODEL_KEY=" + tModel.getTModelKey().toString() + "\n\t AUTHORIZED_NAME=" + tModel.getAuthorizedName() + "\n\t PUBLISHER_ID=" + publisherID + "\n\t OPERATOR=" + tModel.getOperator() + "\n\t NAME=" + tModel.getName().getValue() + "\n\t LANG_CODE=" + tModel.getName().getLanguageCode() + "\n\t OVERVIEW_URL=" + overviewURL + "\n\t LAST_UPDATE=" + timeStamp.getTime() + "\n"));
            }
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String tModelKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, tModelKey.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)(deleteSQL + "\n\t TMODEL_KEY=" + tModelKey.toString() + "\n"));
            }
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsDeleted(String tModelKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(updateSQL);
            statement.setString(1, tModelKey.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)(updateSQL + "\n\t TMODEL_KEY=" + tModelKey.toString() + "\n"));
            }
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TModel select(String tModelKey, Connection connection) throws SQLException {
        TModel tModel = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, tModelKey.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)(selectSQL + "\n\t TMODEL_KEY=" + tModelKey.toString() + "\n"));
            }
            if ((resultSet = statement.executeQuery()).next()) {
                tModel = new TModel();
                tModel.setTModelKey(tModelKey);
                tModel.setAuthorizedName(resultSet.getString(1));
                tModel.setOperator(resultSet.getString(2));
                Name name = new Name();
                name.setValue(resultSet.getString(3));
                name.setLanguageCode(resultSet.getString(4));
                tModel.setName(name);
                OverviewDoc overviewDoc = new OverviewDoc();
                overviewDoc.setOverviewURL(resultSet.getString(5));
                tModel.setOverviewDoc(overviewDoc);
            }
            TModel tModel2 = tModel;
            return tModel2;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector selectByPublisherID(String publisherID, Connection connection) throws SQLException {
        Vector<String> keyList = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectByPublisherSQL);
            statement.setString(1, publisherID.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)(selectByPublisherSQL + "\n\t PUBLISHER_ID=" + publisherID + "\n"));
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keyList.add(resultSet.getString(1));
            }
            Vector<String> vector = keyList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyOwnership(String tModelKey, String publisherID, Connection connection) throws SQLException {
        if (tModelKey == null || publisherID == null) {
            return false;
        }
        boolean authorized = false;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(verifyOwnershipSQL);
            statement.setString(1, tModelKey);
            statement.setString(2, publisherID);
            if (log.isDebugEnabled()) {
                log.debug((Object)(verifyOwnershipSQL + "\n\t TMODEL_KEY=" + tModelKey + "\n\t PUBLISHER_ID=" + publisherID + "\n"));
            }
            if ((resultSet = statement.executeQuery()).next()) {
                authorized = true;
            }
            boolean bl = authorized;
            return bl;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tablePrefix = Config.getStringProperty("juddi.tablePrefix", "");
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO ").append(tablePrefix).append("TMODEL (");
        sql.append("TMODEL_KEY,");
        sql.append("AUTHORIZED_NAME,");
        sql.append("PUBLISHER_ID,");
        sql.append("OPERATOR,");
        sql.append("NAME,");
        sql.append("LANG_CODE,");
        sql.append("OVERVIEW_URL,");
        sql.append("LAST_UPDATE) ");
        sql.append("VALUES (?,?,?,?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM ").append(tablePrefix).append("TMODEL ");
        sql.append("WHERE TMODEL_KEY=?");
        deleteSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("UPDATE ").append(tablePrefix).append("TMODEL ");
        sql.append("SET DELETED='true' ");
        sql.append("WHERE TMODEL_KEY=?");
        updateSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("AUTHORIZED_NAME,");
        sql.append("OPERATOR,");
        sql.append("NAME,");
        sql.append("LANG_CODE,");
        sql.append("OVERVIEW_URL,");
        sql.append("DELETED ");
        sql.append("FROM ").append(tablePrefix).append("TMODEL ");
        sql.append("WHERE TMODEL_KEY=? ");
        sql.append("AND DELETED IS NULL");
        selectSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("TMODEL_KEY,");
        sql.append("DELETED ");
        sql.append("FROM ").append(tablePrefix).append("TMODEL ");
        sql.append("WHERE PUBLISHER_ID=? ");
        sql.append("AND DELETED IS NULL");
        selectByPublisherSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT * ");
        sql.append("FROM ").append(tablePrefix).append("TMODEL ");
        sql.append("WHERE TMODEL_KEY=? ");
        sql.append("AND PUBLISHER_ID=? ");
        sql.append("AND DELETED IS NULL");
        verifyOwnershipSQL = sql.toString();
    }
}

