/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.builder;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.resource.deployers.builder.AbstractBuilder;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.mcf.DataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryTransactionSupportMetaData;
import org.jboss.resource.metadata.repository.DefaultJCAMetaDataRepository;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceInjectionValueMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;

public class ManagedConnectionFactoryBuilder
extends AbstractBuilder {
    private static final String MCF = "org.jboss.resource.connectionmanager.ManagedConnectionFactoryDeployment";
    private static final String RAR_JMX = "jboss.jca:service=RARDeployment,name='";
    private static final String MCF_JMX = "jboss.jca:service=ManagedConnectionFactory,name=";
    private static final String SUBJECT_FACTORY = "JBossSecuritySubjectFactory";
    private static final String TRANSACTION_MANAGER_SERVICE = "jboss:service=TransactionManager";
    private DefaultJCAMetaDataRepository repository;

    public DefaultJCAMetaDataRepository getMetaDataRepository() {
        return this.repository;
    }

    public void setMetaDataRepository(DefaultJCAMetaDataRepository repository) {
        this.repository = repository;
    }

    @Override
    public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md) {
        return ObjectNameFactory.create((String)(MCF_JMX + md.getJndiName()));
    }

    @Override
    public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData deployment) {
        ArrayList<ServiceAttributeMetaData> attributes = new ArrayList<ServiceAttributeMetaData>();
        ServiceAttributeMetaData attribute = this.buildDependencyAttribute("OldRarDeployment", RAR_JMX + deployment.getRarName() + "'");
        attributes.add(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("SubjectFactory");
        ServiceInjectionValueMetaData sf = new ServiceInjectionValueMetaData((Object)SUBJECT_FACTORY);
        attribute.setValue((ServiceValueMetaData)sf);
        attributes.add(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("XAResourceRecoveryRegistry");
        ServiceInjectionValueMetaData xrrr = new ServiceInjectionValueMetaData((Object)TRANSACTION_MANAGER_SERVICE);
        attribute.setValue((ServiceValueMetaData)xrrr);
        attributes.add(attribute);
        return attributes;
    }

    @Override
    public ServiceConstructorMetaData buildConstructor(ManagedConnectionFactoryDeploymentMetaData mcfmd) {
        ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
        ConnectorMetaData md = this.repository.getConnectorMetaData(mcfmd.getRarName());
        if (md == null) {
            throw new IllegalStateException("No ConnectorMetaData found for mdf rarName: " + mcfmd.getRarName());
        }
        constructor.setParameters(new Object[]{md, mcfmd, this.getConnectionManager(mcfmd)});
        constructor.setSignature(new String[]{md.getClass().getName(), ManagedConnectionFactoryDeploymentMetaData.class.getName(), String.class.getName()});
        return constructor;
    }

    @Override
    public List<ServiceDependencyMetaData> buildDependencies(ManagedConnectionFactoryDeploymentMetaData md) {
        List dependsNames = md.getDependsNames();
        ArrayList<ServiceDependencyMetaData> dependencies = new ArrayList<ServiceDependencyMetaData>();
        for (String string : dependsNames) {
            ServiceDependencyMetaData depends = this.buildDependency(string);
            dependencies.add(depends);
        }
        return dependencies;
    }

    @Override
    public String getCode(ManagedConnectionFactoryDeploymentMetaData md) {
        return MCF;
    }

    private String getConnectionManager(ManagedConnectionFactoryDeploymentMetaData md) {
        String cmType = "jboss.jca:service=";
        String jndiName = md.getJndiName();
        cmType = md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.NONE) ? cmType + "NoTxCM,name=" + jndiName : (md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.LOCAL) ? (md instanceof DataSourceDeploymentMetaData ? cmType + "LocalTxCM,name=" + jndiName : cmType + "TxCM,name=" + jndiName) : (md instanceof DataSourceDeploymentMetaData ? cmType + "XATxCM,name=" + jndiName : cmType + "TxCM,name=" + jndiName));
        return cmType;
    }
}

