/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.web.tomcat.service.session.ClusteredManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.OutgoingDistributableSessionDataImpl;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingAttributeGranularitySessionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributeBasedClusteredSession
extends ClusteredSession<OutgoingAttributeGranularitySessionData> {
    static final long serialVersionUID = -5625209785550936713L;
    protected static final String info = "AttributeBasedClusteredSession/1.0";
    private transient Map<String, Object> attrModifiedMap_ = new HashMap<String, Object>();
    private transient Set<String> attrRemovedSet_ = new HashSet<String>();

    public AttributeBasedClusteredSession(ClusteredManager<OutgoingAttributeGranularitySessionData> manager) {
        super(manager);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.clearAttrChangedMaps();
    }

    @Override
    protected OutgoingAttributeGranularitySessionData getOutgoingSessionData() {
        boolean needFull = this.isFullReplicationNeeded();
        HashMap<String, Object> modAttrs = null;
        HashSet<String> removeAttrs = null;
        if (needFull || this.isSessionAttributeMapDirty()) {
            if (needFull) {
                modAttrs = new HashMap<String, Object>(this.getAttributesInternal());
                this.removeExcludedAttributes(modAttrs);
            } else if (this.attrModifiedMap_.size() > 0) {
                modAttrs = new HashMap<String, Object>(this.attrModifiedMap_);
            }
            if (this.attrRemovedSet_.size() > 0) {
                removeAttrs = new HashSet<String>(this.attrRemovedSet_);
            }
            this.clearAttrChangedMaps();
        }
        DistributableSessionMetadata metadata = needFull || this.isSessionMetadataDirty() ? this.getSessionMetadata() : null;
        Long timestamp = modAttrs != null || removeAttrs != null || metadata != null || this.getMustReplicateTimestamp() ? Long.valueOf(this.getSessionTimestamp()) : null;
        return new OutgoingData(this.getRealId(), this.getVersion(), timestamp, metadata, modAttrs, removeAttrs);
    }

    @Override
    protected Object getAttributeInternal(String name) {
        Object result = this.getAttributesInternal().get(name);
        if (this.isGetDirty(result) && !replicationExcludes.contains(name)) {
            this.attributeChanged(name, result, false);
        }
        return result;
    }

    @Override
    protected Object removeAttributeInternal(String name, boolean localCall, boolean localOnly) {
        Object result = this.getAttributesInternal().remove(name);
        if (localCall && !replicationExcludes.contains(name)) {
            this.attributeChanged(name, result, true);
        }
        return result;
    }

    @Override
    protected Object setAttributeInternal(String key, Object value) {
        Object old = this.getAttributesInternal().put(key, value);
        if (!replicationExcludes.contains(key)) {
            this.attributeChanged(key, value, false);
        }
        return old;
    }

    private synchronized void attributeChanged(String key, Object value, boolean removal) {
        if (removal) {
            if (this.attrModifiedMap_.containsKey(key)) {
                this.attrModifiedMap_.remove(key);
            }
            this.attrRemovedSet_.add(key);
        } else {
            if (this.attrRemovedSet_.contains(key)) {
                this.attrRemovedSet_.remove(key);
            }
            this.attrModifiedMap_.put(key, value);
        }
        this.sessionAttributesDirty();
    }

    private synchronized void clearAttrChangedMaps() {
        this.attrRemovedSet_.clear();
        this.attrModifiedMap_.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutgoingData
    extends OutgoingDistributableSessionDataImpl
    implements OutgoingAttributeGranularitySessionData {
        private final Map<String, Object> modifiedAttributes;
        private final Set<String> removedAttributes;

        public OutgoingData(String realId, int version, Long timestamp, DistributableSessionMetadata metadata, Map<String, Object> modifiedAttributes, Set<String> removedAttributes) {
            super(realId, version, timestamp, metadata);
            this.modifiedAttributes = modifiedAttributes;
            this.removedAttributes = removedAttributes;
        }

        public Map<String, Object> getModifiedSessionAttributes() {
            return this.modifiedAttributes;
        }

        public Set<String> getRemovedSessionAttributes() {
            return this.removedAttributes;
        }
    }
}

