/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.ClusterConfigMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossClusteredProcessor
extends AbstractFinderUser
implements Processor<JBossSessionBeanMetaData, Class<?>> {
    protected JBossClusteredProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public void process(JBossSessionBeanMetaData metaData, Class<?> type) {
        Clustered annotation = this.finder.getAnnotation(type, Clustered.class);
        if (annotation == null) {
            return;
        }
        ClusterConfigMetaData clustered = new ClusterConfigMetaData();
        clustered.setBeanLoadBalancePolicy(annotation.loadBalancePolicy());
        clustered.setHomeLoadBalancePolicy(annotation.homeLoadBalancePolicy());
        clustered.setPartitionName(annotation.partition());
        clustered.setDescriptions(ProcessorUtils.getDescription(" @Clustered for bean: " + type));
        metaData.setClusterConfig(clustered);
        metaData.setClustered(true);
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(Clustered.class);
    }
}

