/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.seam.annotations.Namespace;
import org.jboss.seam.deployment.AbstractDeploymentHandler;
import org.jboss.seam.deployment.DeploymentMetadata;
import org.jboss.seam.deployment.FileDescriptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceDeploymentHandler
extends AbstractDeploymentHandler {
    private static DeploymentMetadata NAMESPACE_METADATA = new DeploymentMetadata(){

        public String getFileNameSuffix() {
            return "/package-info.class";
        }
    };
    public static final String NAME = "org.jboss.seam.deployment.NamespaceDeploymentHandler";
    private static final LogProvider log = Logging.getLogProvider(NamespaceDeploymentHandler.class);
    private Set<Package> packages = new HashSet<Package>();

    public Set<Package> getPackages() {
        return Collections.unmodifiableSet(this.packages);
    }

    @Override
    public void postProcess(ClassLoader classLoader) {
        for (FileDescriptor fileDescriptor : this.getResources()) {
            String packageName = NamespaceDeploymentHandler.filenameToPackageName(fileDescriptor.getName());
            Package pkg = NamespaceDeploymentHandler.getPackage(packageName, classLoader);
            if (pkg == null) {
                log.warn("Cannot load package info for " + packageName);
                continue;
            }
            if (pkg.getAnnotation(Namespace.class) == null) continue;
            this.packages.add(pkg);
        }
    }

    private static String filenameToPackageName(String filename) {
        return filename.substring(0, filename.lastIndexOf("/package-info.class")).replace('/', '.').replace('\\', '.');
    }

    private static Package getPackage(String name, ClassLoader classLoader) {
        try {
            Class<?> c = classLoader.loadClass(name + ".package-info");
            return c != null ? c.getPackage() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DeploymentMetadata getMetadata() {
        return NAMESPACE_METADATA;
    }
}

