/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.modelmbean;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.StandardMBean;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.jboss.mx.interceptor.StandardMBeanInfoInterceptor;
import org.jboss.mx.metadata.AbstractBuilder;
import org.jboss.mx.metadata.MBeanInfoConversion;
import org.jboss.mx.metadata.StandardMetaData;
import org.jboss.mx.metadata.XMLMetaData;
import org.jboss.mx.modelmbean.ModelMBeanInvoker;
import org.jboss.mx.modelmbean.XMBeanConstants;
import org.w3c.dom.Element;

public class XMBean
extends ModelMBeanInvoker
implements XMBeanConstants,
NotificationListener {
    public XMBean() throws MBeanException {
        try {
            this.setManagedResource(new Object(), "ObjectReference");
            this.setModelMBeanInfo(new ModelMBeanInfoSupport("XMBean", "Uninitialized XMBean", new ModelMBeanAttributeInfo[0], new ModelMBeanConstructorInfo[0], new ModelMBeanOperationInfo[0], new ModelMBeanNotificationInfo[0]));
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public XMBean(ModelMBeanInfo info) throws MBeanException {
        super(info);
    }

    public XMBean(Object resource, String resourceType) throws MBeanException, NotCompliantMBeanException {
        ModelMBeanInfo minfo = null;
        try {
            AbstractBuilder builder;
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (resourceType.equals("descriptor")) {
                Descriptor d = (Descriptor)resource;
                resourceType = (String)d.getFieldValue("xmbean.resource.type");
                resource = d.getFieldValue("xmbean.resource.reference");
                String[] fields = d.getFieldNames();
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].startsWith("xmbean.metadata.")) continue;
                    properties.put(fields[i], d.getFieldValue(fields[i]));
                }
            }
            if (resourceType.equals("StandardMBean") && resource instanceof StandardMBean) {
                this.setManagedResource(((StandardMBean)resource).getImplementation(), resourceType);
            } else {
                this.setManagedResource(resource, resourceType);
            }
            boolean CREATE_ATTRIBUTE_OPERATION_MAPPING = true;
            if (resourceType.equals("StandardMBean") && resource instanceof StandardMBean) {
                StandardMBean standardMBean = (StandardMBean)resource;
                minfo = MBeanInfoConversion.toModelMBeanInfo(standardMBean.getMBeanInfo(), true);
            } else if (resourceType.equals("StandardInterface") || resourceType.equals("StandardMBean")) {
                this.dynamicResource = false;
                builder = new StandardMetaData(resource);
                for (String key : properties.keySet()) {
                    builder.setProperty(key, properties.get(key));
                }
                MBeanInfo standardInfo = builder.build();
                minfo = MBeanInfoConversion.toModelMBeanInfo(standardInfo, true);
            } else if (resourceType.endsWith(".xml")) {
                builder = new XMLMetaData(this.getClass().getName(), resource.getClass().getName(), resourceType);
                for (String key : properties.keySet()) {
                    builder.setProperty(key, properties.get(key));
                }
                minfo = (ModelMBeanInfo)((Object)builder.build());
            }
            this.setModelMBeanInfo(minfo);
            this.load();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            if (resourceType.endsWith(".xml")) {
                throw new MBeanException(e, "Malformed URL: " + resourceType);
            }
            throw new MBeanException(e, "Unsupported resource type: " + resourceType);
        }
        catch (MalformedURLException e) {
            throw new MBeanException(e, "Malformed URL: " + resourceType);
        }
    }

    public XMBean(Object resource, URL interfaceURL) throws MBeanException, NotCompliantMBeanException {
        this(resource, interfaceURL.toString());
    }

    public XMBean(Descriptor descriptor) throws MBeanException, NotCompliantMBeanException {
        this((Object)descriptor, "descriptor");
    }

    public XMBean(Object resource, Element element, String version) throws MBeanException, NotCompliantMBeanException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document doc = builder.newDocument();
            doc.appendChild(doc.importNode(element, true));
            DOMReader domReader = new DOMReader();
            Document dom4jDoc = domReader.read(doc);
            org.dom4j.Element dom4jElem = dom4jDoc.getRootElement();
            dom4jElem.detach();
            this.createXMBean(resource, dom4jElem, version);
        }
        catch (ParserConfigurationException e) {
            throw new MBeanException(e, "Could not convert w3c Element to dom4j Element.");
        }
    }

    public XMBean(Object resource, org.dom4j.Element element, String version) throws MBeanException, NotCompliantMBeanException {
        this.createXMBean(resource, element, version);
    }

    private void createXMBean(Object resource, org.dom4j.Element element, String version) throws MBeanException, NotCompliantMBeanException {
        try {
            this.setManagedResource(resource, "ObjectReference");
            XMLMetaData builder = new XMLMetaData(this.getClass().getName(), resource.getClass().getName(), element, version);
            ModelMBeanInfo minfo = (ModelMBeanInfo)((Object)builder.build());
            this.setModelMBeanInfo(minfo);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e, "Unsupported resource type: " + this.resourceType);
        }
    }

    public boolean isSupportedResourceType(Object resource, String resourceType) {
        if (resourceType == null) {
            return false;
        }
        if (resourceType.equalsIgnoreCase("ObjectReference")) {
            return true;
        }
        if (resourceType.equalsIgnoreCase("StandardInterface")) {
            return true;
        }
        if (resourceType.equalsIgnoreCase("StandardMBean")) {
            return true;
        }
        if (resourceType.equalsIgnoreCase("descriptor")) {
            if (resource == null || !(resource instanceof Descriptor)) {
                return false;
            }
            Descriptor d = (Descriptor)resource;
            if (d.getFieldValue("xmbean.resource.reference") == null) {
                return false;
            }
            return d.getFieldValue("xmbean.resource.type") != null;
        }
        if (resourceType.endsWith(".xml")) {
            try {
                new URL(resourceType);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }

    protected void configureInterceptorStack(ModelMBeanInfo info, MBeanServer server, ObjectName name) throws Exception {
        super.configureInterceptorStack(info, server, name);
        if (this.resourceType.equals("StandardMBean")) {
            List interceptors = this.getMBeanInfoCtx.getInterceptors();
            interceptors.add(0, new StandardMBeanInfoInterceptor());
            this.getMBeanInfoCtx.setInterceptors(interceptors);
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this.resourceType.equals("StandardMBean")) {
            this.addNotificationListenerToResource(listener, filter, handback);
        } else {
            super.addNotificationListener(listener, filter, handback);
            if (this.getResource() instanceof NotificationBroadcaster) {
                this.addNotificationListenerToResource(listener, filter, handback);
            }
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (this.resourceType.equals("StandardMBean")) {
            this.removeNotificationListenerFromResource(listener);
        } else {
            super.removeNotificationListener(listener);
            if (this.getResource() instanceof NotificationBroadcaster) {
                this.removeNotificationListenerFromResource(listener);
            }
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (this.resourceType.equals("StandardMBean")) {
            this.removeNotificationListenerFromResource(listener, filter, handback);
        } else {
            super.removeNotificationListener(listener, filter, handback);
            if (this.getResource() instanceof NotificationBroadcaster) {
                this.removeNotificationListenerFromResource(listener, filter, handback);
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.resourceType.equals("StandardMBean")) {
            return this.getNotificationInfoFromResource();
        }
        return super.getNotificationInfo();
    }

    public void handleNotification(Notification notification, Object handback) {
        Object resource = this.getResource();
        if (resource instanceof NotificationListener) {
            ((NotificationListener)resource).handleNotification(notification, handback);
        }
    }
}

