/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.IOException;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.XSDTypeToJava;
import org.jboss.ws.tools.interfaces.XSDToJavaIntf;

public class XSDToJava
implements XSDToJavaIntf {
    protected WSDLUtils utils = WSDLUtils.getInstance();
    protected final XSDTypeToJava xsdJava = new XSDTypeToJava(null, false);

    public void generateJavaSource(String schemaFile, File dirloc, String packageName, boolean createPackageDir) throws IOException {
        XSLoader xsloader = SchemaUtils.getInstance().getXSLoader();
        XSModel xsmodel = xsloader.loadURI(schemaFile);
        this.generateJavaSource(xsmodel, dirloc, packageName, createPackageDir);
    }

    public void generateJavaSource(XSModel xsmodel, File dirloc, String packageName, boolean createPackageDir) throws IOException {
        if (createPackageDir) {
            this.utils.createPackage(dirloc.getAbsolutePath(), packageName);
        }
        this.generateJavaSource(xsmodel, dirloc, packageName);
    }

    public void generateJavaSource(XSModel xsmodel, File dirloc, String packageName) throws IOException {
        int i;
        XSNamedMap xsnamedmap = xsmodel.getComponents((short)3);
        int len = xsnamedmap != null ? xsnamedmap.getLength() : 0;
        for (i = 0; i < len; ++i) {
            String tname;
            String nsuri;
            XSObject type = xsnamedmap.item(i);
            if (type instanceof XSComplexTypeDefinition) {
                XSComplexTypeDefinition ctype = (XSComplexTypeDefinition)type;
                nsuri = type.getNamespace();
                tname = type.getName();
                if ("http://www.w3.org/2001/XMLSchema".equals(nsuri) && "anyType".equals(tname)) continue;
                this.xsdJava.createJavaFile(ctype, dirloc.getPath(), packageName, xsmodel);
                continue;
            }
            if (!(type instanceof XSSimpleTypeDefinition)) continue;
            XSSimpleTypeDefinition stype = (XSSimpleTypeDefinition)type;
            nsuri = type.getNamespace();
            tname = type.getName();
            if ("http://www.w3.org/2001/XMLSchema".equals(nsuri) && "anyType".equals(tname)) continue;
            this.xsdJava.createJavaFile(stype, dirloc.getPath(), packageName, xsmodel);
        }
        xsnamedmap = xsmodel.getComponents((short)2);
        len = xsnamedmap != null ? xsnamedmap.getLength() : 0;
        for (i = 0; i < len; ++i) {
            XSElementDeclaration elm = (XSElementDeclaration)xsnamedmap.item(i);
            String elmname = elm.getName();
            XSTypeDefinition elmtype = elm.getTypeDefinition();
            if (elmtype == null || !(elmtype instanceof XSComplexTypeDefinition)) continue;
            XSComplexTypeDefinition ctype = (XSComplexTypeDefinition)elmtype;
            String nsuri = elmtype.getNamespace();
            String tname = elmtype.getName();
            if (tname != null) continue;
            this.createJavaFile(ctype, dirloc, packageName, xsmodel, elmname);
        }
    }

    public void setTypeMapping(LiteralTypeMapping tm) {
        this.xsdJava.setTypeMapping(tm);
    }

    private void createJavaFile(XSComplexTypeDefinition type, File loc, String pkgname, XSModel schema, String outerElementName) throws IOException {
        String str = "Method should be used for anon complex types only";
        if (type.getName() != null) {
            throw new IllegalArgumentException(str);
        }
        this.xsdJava.createJavaFile(type, outerElementName, loc.getPath(), pkgname, schema, false);
    }
}

