/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JDBCUtils {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCUtils");

    private JDBCUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(String tableName, Connection con) {
        boolean bl;
        Statement stmt = null;
        ResultSet trs = null;
        try {
            stmt = con.createStatement();
            trs = stmt.executeQuery("SELECT count(*) FROM " + tableName);
            bl = trs.next();
            Object var7_6 = null;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQLException occurs while checking the table " + tableName), (Throwable)e);
                }
                bl2 = false;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                JDBCUtils.freeResources(trs, stmt, null);
                throw throwable;
            }
            JDBCUtils.freeResources(trs, stmt, null);
            return bl2;
        }
        JDBCUtils.freeResources(trs, stmt, null);
        return bl;
    }

    public static void freeResources(ResultSet resultSet, Statement statement, Connection conn) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

