/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.Annotation;
import com.google.caja.ancillary.jsdoc.BlockAnnotation;
import com.google.caja.ancillary.jsdoc.Comment;
import com.google.caja.ancillary.jsdoc.CommentTokenType;
import com.google.caja.ancillary.jsdoc.InlineAnnotation;
import com.google.caja.ancillary.jsdoc.TextAnnotation;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.TokenStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommentParser {
    private final TokenQueue<CommentTokenType> tq;

    public static Comment parseStructuredComment(CharProducer commentText) throws ParseException {
        FilePosition pos = commentText.filePositionForOffsets(commentText.getOffset(), commentText.getLimit());
        TokenQueue<CommentTokenType> tq = new TokenQueue<CommentTokenType>(new Joiner(commentText), pos.source());
        tq.setInputRange(pos);
        CommentParser p = new CommentParser(tq);
        ArrayList<Annotation> body = new ArrayList<Annotation>();
        while (p.parseBodyPart(body)) {
        }
        while (p.parseBlockAnnotation(body)) {
        }
        if (!p.tq.isEmpty()) {
            throw new IllegalStateException("Unprocessed '" + commentText + "'");
        }
        return new Comment(body, pos);
    }

    private CommentParser(TokenQueue<CommentTokenType> tq) {
        this.tq = tq;
    }

    private boolean parseBodyPart(List<Annotation> out) throws ParseException {
        if (this.tq.isEmpty()) {
            return false;
        }
        Token<CommentTokenType> t = this.tq.peek();
        if (t.type == CommentTokenType.ANNOTATION_NAME) {
            if (t.text.charAt(0) == '{') {
                return this.parseInlineAnnotation(out);
            }
            return false;
        }
        StringBuilder sb = new StringBuilder();
        FilePosition start = t.pos;
        do {
            sb.append(t.text);
            this.tq.advance();
            if (this.tq.isEmpty()) break;
            t = this.tq.peek();
        } while (t.type != CommentTokenType.ANNOTATION_NAME);
        out.add(new TextAnnotation(sb.toString(), FilePosition.span(start, this.tq.lastPosition())));
        return true;
    }

    private boolean parseInlineAnnotation(List<Annotation> out) throws ParseException {
        FilePosition start = this.tq.currentPosition();
        String name = this.tq.expectTokenOfType((CommentTokenType)CommentTokenType.ANNOTATION_NAME).text;
        TextAnnotation body = this.parseInlineBody();
        this.tq.expectToken("}");
        out.add(new InlineAnnotation(name.substring(2), body, this.posFrom(start)));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TextAnnotation parseInlineBody() throws ParseException {
        FilePosition start = this.tq.currentPosition();
        StringBuilder inlineBody = new StringBuilder();
        int bracketDepth = 1;
        while (true) {
            if (this.tq.isEmpty()) {
                this.tq.expectToken("}");
            }
            Token<CommentTokenType> t = this.tq.peek();
            switch ((CommentTokenType)t.type) {
                case OPEN_CURLY: {
                    ++bracketDepth;
                    break;
                }
                case CLOSE_CURLY: {
                    if (--bracketDepth != 0) break;
                    return new TextAnnotation(inlineBody.toString(), this.posFrom(start));
                }
            }
            inlineBody.append(t.text);
            this.tq.advance();
        }
    }

    private boolean parseBlockAnnotation(List<Annotation> out) throws ParseException {
        if (this.tq.isEmpty() || this.tq.peek().type != CommentTokenType.ANNOTATION_NAME || this.tq.peek().text.startsWith("{")) {
            return false;
        }
        FilePosition start = this.tq.currentPosition();
        String name = this.tq.pop().text.substring(1);
        ArrayList<Annotation> body = new ArrayList<Annotation>();
        while (this.parseBodyPart(body)) {
        }
        out.add(new BlockAnnotation(name, body, this.posFrom(start)));
        return true;
    }

    private FilePosition posFrom(FilePosition start) {
        FilePosition end = this.tq.lastPosition();
        if (end.endCharInFile() <= start.startCharInFile()) {
            return FilePosition.startOf(start);
        }
        return FilePosition.span(start, end);
    }

    private static String normalizedCommentString(char[] buf, int s, int e) {
        for (int i = s; i < e; ++i) {
            if (buf[i] != '\r') continue;
            StringBuilder sb = new StringBuilder(e - s);
            int pos = s;
            do {
                if ('\r' != buf[i]) continue;
                sb.append(buf, pos, i - pos).append('\n');
                pos = i + 1;
                if (pos >= e || buf[pos] != '\n') continue;
                ++pos;
            } while (++i < e);
            sb.append(buf, pos, e - pos);
            return sb.toString();
        }
        return String.valueOf(buf, s, e - s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Splitter
    implements TokenStream<CommentTokenType> {
        private final CharProducer cp;
        private Token<CommentTokenType> pending;

        Splitter(CharProducer cp) {
            this.cp = cp;
        }

        @Override
        public boolean hasNext() {
            if (this.pending == null) {
                this.fetch();
            }
            return this.pending != null;
        }

        @Override
        public Token<CommentTokenType> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Token<CommentTokenType> next = this.pending;
            this.pending = null;
            return next;
        }

        private void fetch() {
            int end;
            int limit;
            int start = this.cp.getOffset();
            if (start == (limit = this.cp.getLimit())) {
                return;
            }
            char[] buf = this.cp.getBuffer();
            char ch = buf[start];
            block0 : switch (ch) {
                case '\n': 
                case '\r': {
                    if (ch != '\r' || end >= limit || buf[end] != '\n') break;
                    ++end;
                    break;
                }
                case '\"': 
                case '\'': 
                case '/': 
                case '{': 
                case '}': {
                    break;
                }
                case '@': {
                    for (end = start + 1; end < limit && Character.isLetterOrDigit(buf[end]); ++end) {
                    }
                    break;
                }
                case '\t': 
                case ' ': {
                    while (end < limit && (buf[end] == ' ' || buf[end] == '\t')) {
                        ++end;
                    }
                    break;
                }
                case '*': {
                    while (end < limit && buf[end] == '*') {
                        ++end;
                    }
                    if (end >= limit) break;
                    switch (buf[end]) {
                        case '\t': 
                        case ' ': 
                        case '/': {
                            ++end;
                        }
                    }
                    break;
                }
                default: {
                    while (end < limit) {
                        switch (buf[end]) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': 
                            case '\"': 
                            case '\'': 
                            case '*': 
                            case '{': 
                            case '}': {
                                break block0;
                            }
                        }
                        ++end;
                    }
                    break block0;
                }
            }
            this.cp.consume(end - this.cp.getOffset());
            this.pending = Token.instance(CommentParser.normalizedCommentString(buf, start, end), CommentTokenType.TEXT, this.cp.filePositionForOffsets(start, end));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Filter
    implements TokenStream<CommentTokenType> {
        private final Splitter ts;
        private Token<CommentTokenType> pending;
        private State state = State.START_OF_FILE;

        Filter(CharProducer cp) {
            this.ts = new Splitter(cp);
        }

        @Override
        public boolean hasNext() {
            if (this.pending == null) {
                this.fetch();
            }
            return this.pending != null;
        }

        @Override
        public Token<CommentTokenType> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Token<CommentTokenType> next = this.pending;
            this.pending = null;
            return next;
        }

        private void fetch() {
            this.pending = this.fetchNonIgnorable();
        }

        private Token<CommentTokenType> fetchNonIgnorable() {
            while (this.ts.hasNext()) {
                Token<CommentTokenType> t = this.ts.next();
                char tch = t.text.charAt(0);
                if (tch == '/' && this.state == State.START_OF_FILE) {
                    this.state = State.START_OF_LINE;
                    continue;
                }
                if (tch == '\n') {
                    this.state = State.START_OF_LINE;
                } else {
                    if (tch == '*' && t.text.endsWith("/")) continue;
                    if (this.state != State.IN_LINE) {
                        if (tch == '*') {
                            this.state = State.IN_LINE;
                            continue;
                        }
                        if (tch == ' ' || tch == '*') continue;
                        this.state = State.IN_LINE;
                    }
                }
                return t;
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            START_OF_FILE,
            START_OF_LINE,
            SAW_ASTERISKS,
            IN_LINE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Joiner
    implements TokenStream<CommentTokenType> {
        private final Filter ts;
        private final List<Token<CommentTokenType>> lookahead = new ArrayList<Token<CommentTokenType>>();
        private int bracketDepth = 0;
        private Token<CommentTokenType> pending;

        Joiner(CharProducer cp) {
            this.ts = new Filter(cp);
        }

        @Override
        public boolean hasNext() {
            if (this.pending == null) {
                this.fetch();
            }
            return this.pending != null;
        }

        @Override
        public Token<CommentTokenType> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Token<CommentTokenType> next = this.pending;
            this.pending = null;
            return next;
        }

        private void fetch() {
            Token<CommentTokenType> t0 = this.peek(0);
            if (t0 == null) {
                return;
            }
            char ch0 = t0.text.charAt(0);
            if (this.bracketDepth != 0) {
                switch (ch0) {
                    case '\"': 
                    case '\'': {
                        FilePosition start = t0.pos;
                        FilePosition end = t0.pos;
                        StringBuilder sb = new StringBuilder();
                        sb.append(t0.text);
                        this.consume();
                        while ((t0 = this.peek(0)) != null) {
                            int nEsc;
                            this.consume();
                            sb.append(t0.text);
                            end = t0.pos;
                            if (ch0 != t0.text.charAt(0)) continue;
                            int len = sb.length() - 1;
                            for (nEsc = 0; nEsc < len && sb.charAt(len - nEsc - 1) == '\\'; ++nEsc) {
                            }
                            if ((nEsc & 1) != 0) continue;
                            break;
                        }
                        this.pending = Token.instance(sb.toString(), CommentTokenType.TEXT, FilePosition.span(start, end));
                        break;
                    }
                    case '{': {
                        ++this.bracketDepth;
                        this.consume();
                        this.pending = Token.instance(t0.text, CommentTokenType.OPEN_CURLY, t0.pos);
                        break;
                    }
                    case '}': {
                        --this.bracketDepth;
                        this.consume();
                        this.pending = Token.instance(t0.text, CommentTokenType.CLOSE_CURLY, t0.pos);
                        break;
                    }
                    default: {
                        this.pending = t0;
                        this.consume();
                        break;
                    }
                }
            } else {
                switch (ch0) {
                    case '{': {
                        Token<CommentTokenType> t1 = this.peek(1);
                        if (t1 != null && t1.text.charAt(0) == '@' && t1.text.length() > 1 && Character.isLetter(t1.text.charAt(1))) {
                            this.pending = Token.instance(t0.text + t1.text, CommentTokenType.ANNOTATION_NAME, FilePosition.span(t0.pos, t1.pos));
                            this.consume(2);
                            this.bracketDepth = 1;
                            this.ignoreLeadingSpace();
                            break;
                        }
                        this.pending = t0;
                        this.consume();
                        break;
                    }
                    case '@': {
                        if (t0.text.length() > 1 && Character.isLetter(t0.text.charAt(1))) {
                            this.pending = Token.instance(t0.text, CommentTokenType.ANNOTATION_NAME, t0.pos);
                            this.consume();
                            this.ignoreLeadingSpace();
                            break;
                        }
                        this.pending = t0;
                        this.consume();
                        break;
                    }
                    default: {
                        this.pending = t0;
                        this.consume();
                    }
                }
            }
        }

        private Token<CommentTokenType> peek(int n) {
            while (n >= this.lookahead.size() && this.ts.hasNext()) {
                this.lookahead.add(this.ts.next());
            }
            return this.lookahead.size() > n ? this.lookahead.get(n) : null;
        }

        private void consume() {
            this.lookahead.remove(0);
        }

        private void consume(int n) {
            this.lookahead.subList(0, n).clear();
        }

        private void ignoreLeadingSpace() {
            char ch0;
            Token<CommentTokenType> t = this.peek(0);
            if (t != null && ((ch0 = t.text.charAt(0)) == ' ' || ch0 == '\t')) {
                this.consume();
            }
        }
    }
}

