/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.SourceBreaks;

final class DecodingCharProducer
extends CharProducer {
    private final short[] deltas;
    private final int poffset;
    private final CharProducer p;

    static DecodingCharProducer make(Decoder d, CharProducer p) {
        int plimit = p.getLimit();
        int poffset = p.getOffset();
        int pavail = plimit - poffset;
        char[] pbuf = p.getBuffer();
        short[] deltas = new short[pavail + 1];
        char[] buf = new char[pavail];
        int limit = 0;
        short lastDelta = 0;
        int i = poffset;
        while (i < plimit) {
            d.decode(pbuf, i, plimit);
            int nCodeUnits = Character.charCount(d.codePoint);
            deltas[limit] = lastDelta;
            lastDelta = (short)(deltas[limit] + d.end - i - 1);
            Character.toChars(d.codePoint, buf, limit);
            for (int j = limit + 1; j < limit + nCodeUnits; ++j) {
                deltas[j] = deltas[j - 1];
            }
            limit += nCodeUnits;
            i = d.end;
        }
        if (limit != 0) {
            for (i = limit; i < pavail + 1; ++i) {
                deltas[i] = deltas[i - 1];
            }
        }
        return new DecodingCharProducer(buf, limit, p, deltas, poffset);
    }

    private DecodingCharProducer(DecodingCharProducer orig) {
        super(orig.getBuffer(), orig.getLimit());
        this.deltas = orig.deltas;
        this.poffset = orig.poffset;
        this.p = orig;
        this.consume(orig.getOffset());
    }

    private DecodingCharProducer(char[] buf, int limit, CharProducer p, short[] deltas, int poffset) {
        super(buf, limit);
        this.p = p;
        this.deltas = deltas;
        this.poffset = poffset;
    }

    public int getCharInFile(int offset) {
        return this.p.getCharInFile(this.getUnderlyingOffset(offset));
    }

    public SourceBreaks getSourceBreaks(int offset) {
        return this.p.getSourceBreaks(this.getUnderlyingOffset(offset));
    }

    public CharProducer clone() {
        return new DecodingCharProducer(this);
    }

    public int getUnderlyingOffset(int offset) {
        int nAvail = this.deltas.length;
        return offset - this.poffset + this.deltas[offset >= nAvail ? nAvail - 1 : offset];
    }

    static abstract class Decoder {
        int codePoint;
        int end;

        Decoder() {
        }

        abstract void decode(char[] var1, int var2, int var3);

        boolean decodeHex(char[] buf, int offset, int limit, int end) {
            if (offset == limit) {
                return false;
            }
            int codePoint = 0;
            block5: for (int k = offset; k < limit; ++k) {
                char ch = buf[k];
                switch (ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        codePoint = codePoint << 4 | ch - 48;
                        continue block5;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        codePoint = codePoint << 4 | ch - 97 + 10;
                        continue block5;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        codePoint = codePoint << 4 | ch - 65 + 10;
                        continue block5;
                    }
                    default: {
                        return false;
                    }
                }
            }
            this.end = end;
            this.codePoint = codePoint;
            return true;
        }

        void decodeOctal(char[] buf, int offset, int limit) {
            char ch;
            int k;
            int codePoint = 0;
            for (k = offset; k < limit && '0' <= (ch = buf[k]) && '7' >= ch; ++k) {
                codePoint = codePoint << 3 | ch - 48;
            }
            this.codePoint = codePoint;
            this.end = k;
        }

        boolean decodeDecimal(char[] buf, int offset, int limit, int end) {
            if (offset == limit) {
                return false;
            }
            int codePoint = 0;
            block3: for (int k = offset; k < limit; ++k) {
                char ch = buf[k];
                switch (ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        codePoint = codePoint * 10 + (ch - 48);
                        continue block3;
                    }
                    default: {
                        return false;
                    }
                }
            }
            this.end = end;
            this.codePoint = codePoint;
            return true;
        }
    }
}

