/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.AccessLog;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardEngineValve;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.realm.JAASRealm;
import org.apache.catalina.util.ServerInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.MbeansSource;

public class StandardEngine
extends ContainerBase
implements Engine {
    private static Log log = LogFactory.getLog(StandardEngine.class);
    private String defaultHost = null;
    private static final String info = "org.apache.catalina.core.StandardEngine/1.0";
    private Service service = null;
    private String baseDir = null;
    private String mbeansFile = null;
    private List mbeans;
    private String jvmRouteId;
    private final AtomicReference<AccessLog> defaultAccessLog = new AtomicReference();
    private boolean initialized = false;

    public StandardEngine() {
        this.pipeline.setBasic(new StandardEngineValve());
        try {
            this.setJvmRoute(System.getProperty("jvmRoute"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.backgroundProcessorDelay = 10;
    }

    public Realm getRealm() {
        Realm configured = super.getRealm();
        if (configured == null) {
            configured = new JAASRealm();
            this.setRealm(configured);
        }
        return configured;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String host) {
        String oldDefaultHost = this.defaultHost;
        this.defaultHost = host == null ? null : host.toLowerCase();
        this.support.firePropertyChange("defaultHost", oldDefaultHost, this.defaultHost);
    }

    public void setName(String name) {
        if (this.domain != null) {
            super.setName(this.domain);
            return;
        }
        this.domain = name;
        super.setName(name);
    }

    public void setJvmRoute(String routeId) {
        this.jvmRouteId = routeId;
    }

    public String getJvmRoute() {
        return this.jvmRouteId;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public String getMbeansFile() {
        return this.mbeansFile;
    }

    public void setMbeansFile(String mbeansFile) {
        this.mbeansFile = mbeansFile;
    }

    public String getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.base");
        }
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.home");
        }
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void addChild(Container child) {
        if (!(child instanceof Host)) {
            throw new IllegalArgumentException(sm.getString("standardEngine.notHost"));
        }
        super.addChild(child);
    }

    public String getInfo() {
        return info;
    }

    public void setParent(Container container) {
        throw new IllegalArgumentException(sm.getString("standardEngine.notParent"));
    }

    public void init() {
        String defaultMBeansFile;
        File f;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                if (this.domain == null) {
                    this.domain = this.getName();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register " + this.domain));
                }
                this.controller = this.oname = new ObjectName(this.domain + ":type=Engine");
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Throwable t) {
                log.info((Object)"Error registering ", t);
            }
        }
        if (this.mbeansFile == null && (f = new File(defaultMBeansFile = this.getBaseDir() + "/conf/tomcat5-mbeans.xml")).exists()) {
            this.mbeansFile = f.getAbsolutePath();
        }
        if (this.mbeansFile != null) {
            this.readEngineMbeans();
        }
        if (this.mbeans != null) {
            try {
                Registry.getRegistry(null, null).invoke(this.mbeans, "init", false);
            }
            catch (Exception e) {
                log.error((Object)("Error in init() for " + this.mbeansFile), (Throwable)e);
            }
        }
        if (this.service == null) {
            try {
                this.service = new StandardService();
                this.service.setContainer(this);
                this.service.initialize();
                this.service.setName(this.getName());
            }
            catch (Throwable t) {
                log.error((Object)t);
            }
        }
    }

    public void destroy() throws LifecycleException {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        ((StandardService)this.service).destroy();
        if (this.mbeans != null) {
            try {
                Registry.getRegistry(null, null).invoke(this.mbeans, "destroy", false);
            }
            catch (Exception e) {
                log.error((Object)sm.getString("standardEngine.unregister.mbeans.failed", this.mbeansFile), (Throwable)e);
            }
        }
        if (this.mbeans != null) {
            try {
                for (int i = 0; i < this.mbeans.size(); ++i) {
                    Registry.getRegistry(null, null).unregisterComponent((ObjectName)this.mbeans.get(i));
                }
            }
            catch (Exception e) {
                log.error((Object)sm.getString("standardEngine.unregister.mbeans.failed", this.mbeansFile), (Throwable)e);
            }
        }
        Registry.getRegistry(null, null).resetMetadata();
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.realm == null) {
            ObjectName realmName = null;
            try {
                realmName = new ObjectName(this.domain + ":type=Realm");
                if (this.mserver.isRegistered(realmName)) {
                    this.mserver.invoke(realmName, "init", new Object[0], new String[0]);
                }
            }
            catch (Throwable t) {
                log.debug((Object)("No realm for this engine " + realmName));
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting Servlet Engine: " + ServerInfo.getServerInfo()));
        }
        if (this.mbeans != null) {
            try {
                Registry.getRegistry(null, null).invoke(this.mbeans, "start", false);
            }
            catch (Exception e) {
                log.error((Object)("Error in start() for " + this.mbeansFile), (Throwable)e);
            }
        }
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.mbeans != null) {
            try {
                Registry.getRegistry(null, null).invoke(this.mbeans, "stop", false);
            }
            catch (Exception e) {
                log.error((Object)("Error in stop() for " + this.mbeansFile), (Throwable)e);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardEngine[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public void logAccess(Request request, Response response, long time, boolean useDefault) {
        boolean logged = false;
        if (this.getAccessLog() != null) {
            this.accessLog.log(request, response, time);
            logged = true;
        }
        if (!logged && useDefault) {
            AccessLog newDefaultAccessLog = this.defaultAccessLog.get();
            if (newDefaultAccessLog == null) {
                AccessLogListener l;
                boolean checkHost;
                Host host = (Host)this.findChild(this.getDefaultHost());
                Context context = null;
                boolean bl = checkHost = host != null;
                if (checkHost && host instanceof ContainerBase) {
                    checkHost = ((ContainerBase)((Object)host)).started;
                }
                if (checkHost) {
                    newDefaultAccessLog = host.getAccessLog();
                    if (newDefaultAccessLog != null) {
                        if (this.defaultAccessLog.compareAndSet(null, newDefaultAccessLog)) {
                            l = new AccessLogListener(this, host, null);
                            l.install();
                        }
                    } else {
                        boolean checkContext;
                        context = (Context)host.findChild("");
                        boolean bl2 = checkContext = context != null;
                        if (checkContext && context instanceof ContainerBase) {
                            checkContext = ((ContainerBase)((Object)context)).started;
                        }
                        if (checkContext && (newDefaultAccessLog = context.getAccessLog()) != null && this.defaultAccessLog.compareAndSet(null, newDefaultAccessLog)) {
                            AccessLogListener l2 = new AccessLogListener(this, null, context);
                            l2.install();
                        }
                    }
                }
                if (newDefaultAccessLog == null && this.defaultAccessLog.compareAndSet(null, newDefaultAccessLog = new ContainerBase.NoopAccessLog())) {
                    l = new AccessLogListener(this, host, context);
                    l.install();
                }
            }
            newDefaultAccessLog.log(request, response, time);
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        super.preRegister(server, name);
        this.setName(name.getDomain());
        return name;
    }

    public ObjectName getParentName() throws MalformedObjectNameException {
        if (this.getService() == null) {
            return null;
        }
        String name = this.getService().getName();
        ObjectName serviceName = new ObjectName(this.domain + ":type=Service,serviceName=" + name);
        return serviceName;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create ObjectName " + domain + " " + parent));
        }
        return new ObjectName(domain + ":type=Engine");
    }

    private void readEngineMbeans() {
        try {
            MbeansSource mbeansMB = new MbeansSource();
            File mbeansF = new File(this.mbeansFile);
            mbeansMB.setSource((Object)mbeansF);
            Registry.getRegistry(null, null).registerComponent((Object)mbeansMB, this.domain + ":type=MbeansFile", null);
            mbeansMB.load();
            mbeansMB.init();
            mbeansMB.setRegistry(Registry.getRegistry(null, null));
            this.mbeans = mbeansMB.getMBeans();
        }
        catch (Throwable t) {
            log.error((Object)("Error loading " + this.mbeansFile), t);
        }
    }

    public String getDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        return this.getName();
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    protected static final class AccessLogListener
    implements PropertyChangeListener,
    LifecycleListener,
    ContainerListener {
        private StandardEngine engine;
        private Host host;
        private Context context;
        private volatile boolean disabled = false;

        public AccessLogListener(StandardEngine engine, Host host, Context context) {
            this.engine = engine;
            this.host = host;
            this.context = context;
        }

        public void install() {
            this.engine.addPropertyChangeListener(this);
            if (this.host != null) {
                this.host.addContainerListener(this);
                if (this.host instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.host)).addLifecycleListener(this);
                }
            }
            if (this.context instanceof Lifecycle) {
                ((Lifecycle)((Object)this.context)).addLifecycleListener(this);
            }
        }

        private void uninstall() {
            this.disabled = true;
            if (this.context instanceof Lifecycle) {
                ((Lifecycle)((Object)this.context)).removeLifecycleListener(this);
            }
            if (this.host != null) {
                if (this.host instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.host)).removeLifecycleListener(this);
                }
                this.host.removeContainerListener(this);
            }
            this.engine.removePropertyChangeListener(this);
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (this.disabled) {
                return;
            }
            String type = event.getType();
            if ("after_start".equals(type) || "before_stop".equals(type) || "destroy".equals(type)) {
                this.engine.defaultAccessLog.set(null);
                this.uninstall();
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.disabled) {
                return;
            }
            if ("defaultHost".equals(evt.getPropertyName())) {
                this.engine.defaultAccessLog.set(null);
                this.uninstall();
            }
        }

        public void containerEvent(ContainerEvent event) {
            Context context;
            if (this.disabled) {
                return;
            }
            if ("addChild".equals(event.getType()) && "".equals((context = (Context)event.getData()).getPath())) {
                this.engine.defaultAccessLog.set(null);
                this.uninstall();
            }
        }
    }
}

