/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.input;

import java.io.Writer;
import java.util.HashMap;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Serialized
public class UICheckBoxInput
extends UIFormInputBase<Boolean> {
    private String onchange_;
    private String componentEvent_ = null;

    public UICheckBoxInput() {
        this(null, null, false);
    }

    public UICheckBoxInput(String name, String bindingExpression, Boolean value) {
        super(name, bindingExpression, Boolean.class);
        this.setValue(value);
    }

    @Override
    public UIFormInput<Boolean> setValue(Boolean value) {
        if (value == null) {
            value = false;
        }
        return super.setValue(value);
    }

    public boolean isChecked() {
        return (Boolean)this.getValue();
    }

    public UICheckBoxInput setChecked(boolean check) {
        return (UICheckBoxInput)this.setValue(check);
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    public void setComponentEvent(String com) {
        this.componentEvent_ = com;
    }

    public void setOnChange(String event, String com) {
        this.onchange_ = event;
        this.componentEvent_ = com;
    }

    public String renderOnChangeEvent(UIForm uiForm) throws Exception {
        if (this.componentEvent_ == null) {
            return uiForm.event(this.onchange_, null);
        }
        return uiForm.event(this.onchange_, this.componentEvent_, null);
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        if (this.isDisabled()) {
            return;
        }
        if (input == null || "false".equals(input.toString())) {
            this.setValue(false);
        } else {
            this.setValue(true);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("type", "checkbox");
        attributes.put("name", this.name);
        attributes.put("class", "checkbox");
        if (this.onchange_ != null) {
            UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
            attributes.put("onclick", this.renderOnChangeEvent(uiForm));
        }
        if (this.isChecked()) {
            attributes.put("checked", "checked");
        }
        if (this.isDisabled()) {
            attributes.put("disabled", "disabled");
        }
        this.renderInputBaseComponent(w, "input", attributes);
        if (this.isMandatory()) {
            w.write(" *");
        }
    }
}

