/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.opensocial;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.opensocial.DefaultGadgetRewriter;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Lists;
import com.google.caja.util.TestUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGadgetRewriterTest
extends CajaTestCase {
    private static final UriFetcher FETCHER = new UriFetcher(){

        public FetchedData fetch(ExternalReference extref, String mimeType) throws UriFetcher.UriFetchException {
            if ("file".equals(extref.getUri().getScheme()) && extref.getUri().toString().startsWith(TestUtil.getResource(this.getClass(), "").toString())) {
                InputSource is = new InputSource(extref.getUri());
                try {
                    return FetchedData.fromStream(new FileInputStream(extref.getUri().getPath()), mimeType, "UTF-8", is);
                }
                catch (IOException ex) {
                    throw new UriFetcher.UriFetchException(extref, mimeType, ex);
                }
            }
            throw new UriFetcher.UriFetchException(extref, mimeType);
        }
    };
    private static final UriPolicy POLICY = new UriPolicy(){

        @Override
        public String rewriteUri(ExternalReference u, UriPolicy.UriEffect effect, UriPolicy.LoaderType loader, Map<String, ?> hint) {
            return "http://url-proxy.test.google.com/?url=" + UriUtil.encode(u.getUri().toString()) + "&effect=" + (Object)((Object)effect) + "&loader=" + (Object)((Object)loader);
        }
    };
    private DefaultGadgetRewriter rewriter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.rewriter = new DefaultGadgetRewriter(new TestBuildInfo(), new EchoingMessageQueue(new PrintWriter(System.err), this.mc, false)){

            protected RenderContext createRenderContext(TokenConsumer out) {
                return new RenderContext(out);
            }
        };
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.rewriter = null;
    }

    public final void testInlineGadget() throws Exception {
        this.assertRewritePasses("listfriends-inline.xml", MessageLevel.WARNING);
    }

    public final void testSocialHelloWorld() throws Exception {
        this.assertRewritePasses("SocialHelloWorld.xml", MessageLevel.WARNING);
    }

    public final void testParsing() throws Exception {
        this.assertRewritePasses("test-parsing.xml", MessageLevel.WARNING);
    }

    public final void testSourcedGadget() throws Exception {
        this.assertRewritePasses("listfriends.xml", MessageLevel.WARNING);
    }

    public final void testExampleGadget() throws Exception {
        this.assertRewriteMatches("example.xml", "example-rewritten.xml", MessageLevel.ERROR);
    }

    public final void testTargetsDisallowed() throws Exception {
        this.assertRewritesWithMessage("<a target=\"_top\">Redirect window</a>", "attribute target cannot have value _top", MessageLevel.WARNING, false);
    }

    public final void testMetaRefreshDisallowed() throws Exception {
        this.assertRewritesWithMessage("<meta http-equiv=\"refresh\" content=\"5;http://foo.com\"/>", "removing disallowed tag meta", MessageLevel.WARNING, false);
    }

    public final void testStylesSanitized() throws Exception {
        this.assertRewritesWithMessage("<p style=\"color: expression(foo)\">Bar</p>", "css property color has bad value: ==>expression(foo)<==", MessageLevel.WARNING, false);
    }

    private void assertRewritePasses(String file, MessageLevel failLevel) throws Exception {
        URI gadgetUri = TestUtil.getResource(((Object)((Object)this)).getClass(), file);
        this.rewriter.rewrite(gadgetUri, this.fromResource(file), FETCHER, POLICY, "canvas", System.out);
        this.checkMessages(failLevel);
    }

    private void assertRewriteMatches(String file, String goldenFile, MessageLevel failLevel) throws Exception {
        URI gadgetUri = TestUtil.getResource(((Object)((Object)this)).getClass(), file);
        CharProducer cp = this.fromResource(file);
        StringBuilder sb = new StringBuilder();
        this.rewriter.rewrite(gadgetUri, cp, FETCHER, POLICY, "canvas", sb);
        String actual = DefaultGadgetRewriterTest.normalXml(sb.toString()).trim();
        this.checkMessages(failLevel);
        String expected = DefaultGadgetRewriterTest.normalXml(TestUtil.readResource(((Object)((Object)this)).getClass(), goldenFile)).trim();
        if (!expected.equals(actual)) {
            DefaultGadgetRewriterTest.assertEquals((String)actual, (String)DefaultGadgetRewriterTest.normalizeIndentation(expected), (String)DefaultGadgetRewriterTest.normalizeIndentation(actual));
        }
    }

    private static String normalXml(String xml) {
        return xml.replaceFirst("^<\\?xml[^>]*>", "");
    }

    private void assertRewritesWithMessage(String htmlContent, String msg, MessageLevel level, boolean rewriteShouldFail) throws Exception {
        String input = "<?xml version=\"1.0\"?><Module><ModulePrefs title=\"Example Gadget\"><Require feature=\"opensocial-0.5\"/></ModulePrefs><Content type=\"html\"><![CDATA[" + htmlContent + "]]>" + "</Content>" + "</Module>";
        URI gadgetUri = URI.create("http://unittest.google.com/foo/bar/");
        CharProducer cp = this.fromString(input, new InputSource(gadgetUri));
        try {
            this.rewriter.rewrite(gadgetUri, cp, FETCHER, POLICY, "canvas", System.out);
            if (rewriteShouldFail) {
                DefaultGadgetRewriterTest.fail((String)("rewrite should have failed with message " + msg));
            }
        }
        catch (GadgetRewriteException ex) {
            // empty catch block
        }
        List<Message> errors = this.getMessagesExceedingLevel(level);
        DefaultGadgetRewriterTest.assertFalse((String)("Expected error msg: " + msg), (boolean)errors.isEmpty());
        String actualMsg = errors.get(0).format(new MessageContext());
        actualMsg = actualMsg.substring(actualMsg.indexOf(": ") + 2).trim();
        DefaultGadgetRewriterTest.assertEquals((String)msg, (String)actualMsg);
    }

    private List<Message> getMessagesExceedingLevel(MessageLevel limit) {
        List<Message> matches = Lists.newArrayList();
        for (Message msg : this.rewriter.getMessageQueue().getMessages()) {
            if (msg.getMessageLevel().compareTo(limit) < 0) continue;
            matches.add(msg);
        }
        return matches;
    }

    private void checkMessages(MessageLevel failLevel) {
        List<Message> failures = this.getMessagesExceedingLevel(failLevel);
        MessageContext mc = new MessageContext();
        if (!failures.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Message failure : failures) {
                sb.append((Object)failure.getMessageLevel()).append(" : ").append(failure.format(mc)).append('\n');
            }
            DefaultGadgetRewriterTest.fail((String)sb.toString().trim());
        }
    }

    private static final String normalizeIndentation(String xml) {
        return xml.replaceAll("\n +([?:.])", "$1").replaceAll("\\(\n +", "(").replaceAll("\n *", " ");
    }
}

