/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlLinkedList;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorLinkedList
extends RowSetNavigator {
    HsqlLinkedList list = new HsqlLinkedList();
    final HsqlLinkedList.Node root;
    HsqlLinkedList.Node previous;
    HsqlLinkedList.Node current = this.root = this.list.getHeadNode();

    @Override
    public Object[] getCurrent() {
        return ((Row)this.current.data).getData();
    }

    @Override
    public Row getCurrentRow() {
        return (Row)this.current.data;
    }

    @Override
    public Row getNextRow() {
        return this.next() ? (Row)this.current.data : null;
    }

    @Override
    public void remove() {
        if (this.previous == null) {
            throw new NoSuchElementException();
        }
        if (this.currentPos < this.size && this.currentPos != -1) {
            this.list.removeAfter(this.previous);
            this.current = this.previous;
            --this.size;
            --this.currentPos;
            return;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean next() {
        boolean bl = super.next();
        if (bl) {
            this.previous = this.current;
            this.current = this.current.next;
        }
        return bl;
    }

    @Override
    public void reset() {
        super.reset();
        this.current = this.root;
        this.previous = null;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) throws IOException {
        this.beforeFirst();
        rowOutputInterface.writeLong(this.id);
        rowOutputInterface.writeInt(this.size);
        rowOutputInterface.writeInt(0);
        rowOutputInterface.writeInt(this.size);
        while (this.hasNext()) {
            Object[] objectArray = this.getNext();
            rowOutputInterface.writeData(resultMetaData.getColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
        this.beforeFirst();
    }

    @Override
    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) throws IOException {
        this.id = rowInputInterface.readLong();
        int n = rowInputInterface.readInt();
        rowInputInterface.readInt();
        rowInputInterface.readInt();
        while (n-- > 0) {
            this.add(rowInputInterface.readData(resultMetaData.columnTypes));
        }
    }

    @Override
    public void clear() {
        this.reset();
        this.list.clear();
        this.size = 0;
    }

    @Override
    public void add(Object[] objectArray) {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    @Override
    public boolean addRow(Row row) {
        this.list.add(row);
        ++this.size;
        return true;
    }
}

