/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestMessage
extends OAuthMessage {
    private final HttpServletRequest request;

    public HttpRequestMessage(HttpServletRequest request, String URL) {
        super(request.getMethod(), URL, HttpRequestMessage.getParameters(request));
        this.request = request;
        HttpRequestMessage.copyHeaders(request, this.getHeaders());
    }

    public InputStream getBodyAsStream() throws IOException {
        return this.request.getInputStream();
    }

    public String getBodyEncoding() {
        return this.request.getCharacterEncoding();
    }

    private static void copyHeaders(HttpServletRequest request, Collection<Map.Entry<String, String>> into) {
        Enumeration names = request.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Enumeration values = request.getHeaders(name);
                if (values == null) continue;
                while (values.hasMoreElements()) {
                    into.add((Map.Entry<String, String>)new OAuth.Parameter(name, (String)values.nextElement()));
                }
            }
        }
    }

    public static List<OAuth.Parameter> getParameters(HttpServletRequest request) {
        ArrayList<OAuth.Parameter> list = new ArrayList<OAuth.Parameter>();
        Enumeration headers = request.getHeaders("Authorization");
        while (headers != null && headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            for (OAuth.Parameter parameter : OAuthMessage.decodeAuthorization((String)header)) {
                if ("realm".equalsIgnoreCase(parameter.getKey())) continue;
                list.add(parameter);
            }
        }
        Iterator i$ = request.getParameterMap().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = i$.next();
            String name = (String)entry.getKey();
            for (String value : (String[])entry.getValue()) {
                list.add(new OAuth.Parameter(name, value));
            }
        }
        return list;
    }
}

