/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import groovy.lang.GString;
import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.utils.Text;

abstract class GroovyPrinter
extends GroovyObjectSupport
implements GroovyInterceptable {
    private Locale locale;

    GroovyPrinter() {
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Object invokeMethod(String name, Object args) {
        Object[] array;
        if (args instanceof Object[] && (array = (Object[])args).length == 1) {
            if ("print".equals(name)) {
                this.print(array[0]);
                return null;
            }
            if ("println".equals(name)) {
                this.println(array[0]);
                return null;
            }
        }
        return super.invokeMethod(name, args);
    }

    public final void println(Object o) {
        this.print(o);
        this.println();
    }

    public final void println() {
        try {
            this.write('\n');
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object format(Object o) {
        if (o instanceof Date && this.locale != null) {
            DateFormat dateFormat = DateFormat.getDateInstance(2, this.locale);
            o = dateFormat.format((Date)o);
        }
        return o;
    }

    private String toString(Object o) {
        Object f = this.format(o);
        if (f == null) {
            return "null";
        }
        if (f instanceof String) {
            return (String)f;
        }
        return o.toString();
    }

    public final void print(Object o) {
        try {
            if (o instanceof Text) {
                this.write((Text)o);
            } else if (o instanceof GString) {
                GString gs = (GString)o;
                Object[] values = gs.getValues();
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.format(values[i]);
                }
                this.write(o.toString());
            } else {
                this.write(this.toString(o));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract Writer getWriter();

    protected abstract void write(char var1) throws IOException;

    protected abstract void write(String var1) throws IOException;

    protected abstract void write(Text var1) throws IOException;

    protected abstract void flush() throws IOException;

    protected abstract void close() throws IOException;
}

