/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemDataCopyVisitor
extends ItemDataTraversingVisitor {
    public AbstractItemDataCopyVisitor(ItemDataConsumer dataManager, int maxLevel) {
        super(dataManager, maxLevel);
    }

    public AbstractItemDataCopyVisitor(ItemDataConsumer dataManager) {
        super(dataManager);
    }

    protected List<ValueData> copyValues(PropertyData property) throws RepositoryException {
        List<ValueData> src = property.getValues();
        ArrayList<ValueData> copy = new ArrayList<ValueData>(src.size());
        try {
            for (ValueData vd : src) {
                if (vd.isByteArray()) {
                    copy.add(new TransientValueData(vd.getOrderNumber(), vd.getAsByteArray()));
                    continue;
                }
                copy.add(new TransientValueData(vd.getOrderNumber(), vd.getAsStream()));
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Error of Value copy " + property.getQPath().getAsString(), (Throwable)e);
        }
        return copy;
    }
}

