/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.demos.playground.client.ui;

import com.google.caja.demos.playground.client.Playground;
import com.google.caja.demos.playground.client.PlaygroundResource;
import com.google.caja.demos.playground.client.ui.Example;
import com.google.caja.demos.playground.client.ui.Menu;
import com.google.caja.demos.playground.client.ui.PlaygroundEditor;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.ScriptElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DecoratedTabPanel;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.HorizontalSplitPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class PlaygroundView {
    private final boolean EXPERIMENTAL_MODE = false;
    private HTML renderPanel;
    private TextBox renderResult;
    private HTML cajoledSource;
    private FlexTable compileMessages;
    private FlexTable runtimeMessages;
    private Button speedtracerManifestButton;
    private DecoratedTabPanel editorPanel;
    private Label version = new Label("Unknown");
    private Playground controller;
    private PlaygroundEditor sourceText;
    private TextArea policyText;
    private String currentPolicy;
    private HorizontalPanel loadingLabel;
    private SuggestBox addressField;
    private SuggestBox policyAddressField;
    private MultiWordSuggestOracle sourceExamples;
    private MultiWordSuggestOracle policyExamples;

    public void setVersion(String v) {
        this.version.setText(v);
    }

    public void setPolicyUrl(String url) {
        this.policyAddressField.setText(url);
        this.policyExamples.add(url);
    }

    public void setUrl(String url) {
        this.addressField.setText(url);
        this.sourceExamples.add(url);
    }

    public void selectTab(Tabs tab) {
        this.editorPanel.selectTab(tab.ordinal());
    }

    private Widget createFeedbackPanel() {
        HorizontalPanel feedbackPanel = new HorizontalPanel();
        feedbackPanel.setWidth("100%");
        feedbackPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        for (Menu menu : Menu.values()) {
            Anchor menuItem = new Anchor();
            menuItem.setHTML(menu.description);
            menuItem.setHref(menu.url);
            menuItem.setWordWrap(false);
            menuItem.addStyleName("menuItems");
            feedbackPanel.add((Widget)menuItem);
            feedbackPanel.setCellWidth((Widget)menuItem, "100%");
        }
        return feedbackPanel;
    }

    private Widget createLogoPanel() {
        HorizontalPanel logoPanel = new HorizontalPanel();
        VerticalPanel infoPanel = new VerticalPanel();
        Label title = new Label("Caja Playground");
        infoPanel.add((Widget)title);
        infoPanel.add((Widget)this.version);
        infoPanel.setStyleName("pg_info");
        logoPanel.add((Widget)new Image(PlaygroundResource.INSTANCE.logo().getURL()));
        logoPanel.add((Widget)infoPanel);
        this.loadingLabel = new HorizontalPanel();
        this.loadingLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.loadingLabel.add((Widget)new Label("Loading... "));
        this.loadingLabel.add((Widget)new Image(PlaygroundResource.INSTANCE.loading().getURL()));
        this.loadingLabel.setStyleName("loadingLabel");
        this.loadingLabel.setVisible(false);
        logoPanel.add((Widget)this.loadingLabel);
        return logoPanel;
    }

    private Widget createSourcePanel() {
        this.sourceExamples = new MultiWordSuggestOracle();
        for (Example eg : Example.values()) {
            this.sourceExamples.add(eg.url);
        }
        this.addressField = new SuggestBox((SuggestOracle)this.sourceExamples);
        this.addressField.getTextBox().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                PlaygroundView.this.addressField.showSuggestionList();
            }
        });
        this.addressField.setText("http://");
        this.addressField.setWidth("100%");
        Button goButton = new Button("\u21b4\u00a0Load");
        goButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlaygroundView.this.controller.loadSource(PlaygroundView.this.addressField.getText());
            }
        });
        Button cajoleButton = new Button("Cajole\u00a0\u21b1");
        final ToggleButton debugModeButton = new ToggleButton("No Debug", "Debug");
        debugModeButton.setDown(true);
        cajoleButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlaygroundView.this.runtimeMessages.clear();
                PlaygroundView.this.compileMessages.clear();
                PlaygroundView.this.cajoledSource.setText("");
                PlaygroundView.this.renderPanel.setText("");
                PlaygroundView.this.controller.cajole(PlaygroundView.this.addressField.getText(), PlaygroundView.this.sourceText.getText(), PlaygroundView.this.currentPolicy, Boolean.TRUE.equals(debugModeButton.isDown()));
            }
        });
        Grid addressBar = new Grid(1, 4);
        int item = 0;
        addressBar.setStyleName("playgroundUI");
        addressBar.setWidget(0, item, (Widget)this.addressField);
        addressBar.getCellFormatter().setWidth(0, item++, "80%");
        addressBar.setWidget(0, item++, (Widget)debugModeButton);
        addressBar.setWidget(0, item++, (Widget)goButton);
        addressBar.setWidget(0, item++, (Widget)cajoleButton);
        addressBar.setWidth("95%");
        this.sourceText = new PlaygroundEditor();
        this.sourceText.setSize("95%", "100%");
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setWidth("100%");
        mainPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        mainPanel.add((Widget)addressBar);
        mainPanel.setCellHeight((Widget)addressBar, "0%");
        mainPanel.add((Widget)this.sourceText);
        mainPanel.setCellHeight((Widget)this.sourceText, "100%");
        return mainPanel;
    }

    private Widget createPolicyPanel() {
        this.policyExamples = new MultiWordSuggestOracle();
        this.policyAddressField = new SuggestBox((SuggestOracle)this.policyExamples);
        this.policyAddressField.getTextBox().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                PlaygroundView.this.policyAddressField.showSuggestionList();
            }
        });
        this.policyAddressField.setText("http://");
        this.policyAddressField.setWidth("100%");
        Button clearButton = new Button("Clear");
        clearButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlaygroundView.this.currentPolicy = "";
                PlaygroundView.this.controller.clearPolicy();
            }
        });
        Button loadButton = new Button("\u21b4\u00a0Load");
        loadButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlaygroundView.this.controller.loadPolicy(PlaygroundView.this.policyAddressField.getText());
            }
        });
        Button applyButton = new Button("Apply\u00a0\u21b1");
        applyButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlaygroundView.this.currentPolicy = PlaygroundView.this.policyText.getText();
            }
        });
        Grid addressBar = new Grid(1, 4);
        int item = 0;
        addressBar.setStyleName("playgroundUI");
        addressBar.setWidget(0, item, (Widget)this.policyAddressField);
        addressBar.getCellFormatter().setWidth(0, item++, "80%");
        addressBar.setWidget(0, item++, (Widget)loadButton);
        addressBar.setWidget(0, item++, (Widget)applyButton);
        addressBar.setWidget(0, item++, (Widget)clearButton);
        addressBar.setWidth("95%");
        this.policyText = new TextArea();
        this.setDefaultPolicy(this.policyText);
        this.policyText.setSize("95%", "100%");
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setWidth("100%");
        mainPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        mainPanel.add((Widget)addressBar);
        mainPanel.setCellHeight((Widget)addressBar, "0%");
        mainPanel.add((Widget)this.policyText);
        mainPanel.setCellHeight((Widget)this.policyText, "100%");
        return mainPanel;
    }

    private void setDefaultPolicy(TextArea policyText) {
        this.currentPolicy = PlaygroundResource.INSTANCE.defaultPolicy().getText();
        policyText.setText(this.currentPolicy);
    }

    private Widget createCajoledSourcePanel() {
        FlowPanel fp = new FlowPanel();
        this.cajoledSource = new HTML();
        this.cajoledSource.setSize("100%", "100%");
        this.cajoledSource.getElement().setClassName("prettyPrint");
        fp.add((Widget)this.cajoledSource);
        return fp;
    }

    private Widget createCompileMessagesPanel() {
        FlowPanel hp = new FlowPanel();
        hp.setSize("100%", "100%");
        this.compileMessages = new FlexTable();
        this.compileMessages.setWidth("100%");
        hp.add((Widget)this.compileMessages);
        return hp;
    }

    private Widget createRuntimeMessagesPanel() {
        FlowPanel hp = new FlowPanel();
        hp.setSize("100%", "100%");
        this.runtimeMessages = new FlexTable();
        this.runtimeMessages.setWidth("100%");
        hp.add((Widget)this.runtimeMessages);
        this.setupNativeRuntimeMessageBridge();
        return hp;
    }

    static native String encodeURIComponent(String var0);

    private static native boolean srcLocMapAndOriginalSrc(String var0, String[] var1);

    private Widget createSpeedtracerPanel() {
        FlowPanel hp = new FlowPanel();
        hp.setSize("100%", "100%");
        this.speedtracerManifestButton = new Button("Manifest URI", new ClickHandler(){
            PopupPanel panel;
            Label uriLbl;

            private String getManifestUri() {
                String[] locMapAndSrc = new String[2];
                if (PlaygroundView.srcLocMapAndOriginalSrc(PlaygroundView.this.cajoledSource.getText(), locMapAndSrc)) {
                    String json = "[[" + locMapAndSrc[0] + "],[" + locMapAndSrc[1] + "]]";
                    return "data:text/plain," + PlaygroundView.encodeURIComponent(json);
                }
                return null;
            }

            public void onClick(ClickEvent event) {
                String dataUri = this.getManifestUri();
                if (this.panel == null) {
                    HorizontalPanel body = new HorizontalPanel();
                    this.uriLbl = new Label();
                    body.add((Widget)this.uriLbl);
                    body.add((Widget)new Button("\u00d7", new ClickHandler(){

                        public void onClick(ClickEvent ev) {
                            panel.hide();
                        }
                    }));
                    this.panel = new PopupPanel();
                    this.panel.setWidget((Widget)body);
                    this.panel.setTitle("Manifest URI");
                }
                this.uriLbl.setText(dataUri);
                if (this.panel.isShowing()) {
                    this.panel.hide();
                } else {
                    this.panel.show();
                }
            }
        });
        hp.add((Widget)this.speedtracerManifestButton);
        return hp;
    }

    private native void setupNativeRuntimeMessageBridge();

    private native void setupNativeSelectLineBridge();

    private Widget createEditorPanel() {
        this.editorPanel = new DecoratedTabPanel();
        this.editorPanel.setStyleName("clearPadding");
        this.editorPanel.add(this.createSourcePanel(), "Source");
        this.editorPanel.add(this.createPolicyPanel(), "Policy");
        this.editorPanel.add(this.createCajoledSourcePanel(), "Cajoled Source");
        this.editorPanel.add(this.createRenderPanel(), "Rendered Result");
        this.editorPanel.add(this.createCompileMessagesPanel(), "Compile Warnings/Errors");
        this.editorPanel.add(this.createRuntimeMessagesPanel(), "Runtime Warnings/Errors");
        this.setupNativeSelectLineBridge();
        this.editorPanel.setSize("100%", "100%");
        this.editorPanel.getDeckPanel().setSize("100%", "100%");
        this.selectTab(Tabs.SOURCE);
        return this.editorPanel;
    }

    private Widget createRenderPanel() {
        DisclosurePanel resultBar = new DisclosurePanel("Eval Result");
        resultBar.setStyleName("playgroundUI");
        this.renderResult = new TextBox();
        this.renderResult.setWidth("100%");
        resultBar.add((Widget)this.renderResult);
        resultBar.setWidth("100%");
        this.renderPanel = new HTML();
        FlowPanel mainPanel = new FlowPanel();
        mainPanel.add((Widget)resultBar);
        mainPanel.add((Widget)this.renderPanel);
        this.renderPanel.setSize("100%", "100%");
        return mainPanel;
    }

    private TreeItem addExampleItem(Map<Example.Type, TreeItem> menu, Example eg) {
        if (!menu.containsKey((Object)eg.type)) {
            TreeItem menuItem = new TreeItem(eg.type.description);
            menu.put(eg.type, menuItem);
        }
        TreeItem egItem = new TreeItem(eg.description);
        menu.get((Object)eg.type).addItem(egItem);
        return egItem;
    }

    private Widget createExamplePanel() {
        DecoratedTabPanel cp = new DecoratedTabPanel();
        cp.setStyleName("clearPadding");
        Tree exampleTree = new Tree();
        TreeMap<Example.Type, TreeItem> menuMap = new TreeMap<Example.Type, TreeItem>();
        final HashMap<TreeItem, Example> entryMap = new HashMap<TreeItem, Example>();
        exampleTree.setTitle("Select an example");
        for (Example eg : Example.values()) {
            TreeItem it = this.addExampleItem(menuMap, eg);
            entryMap.put(it, eg);
        }
        for (TreeItem menuItem : menuMap.values()) {
            exampleTree.addItem(menuItem);
        }
        exampleTree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                Example eg = (Example)((Object)entryMap.get(event.getSelectedItem()));
                if (null == eg) {
                    return;
                }
                PlaygroundView.this.controller.loadSource(eg.url);
            }
        });
        cp.setSize("100%", "auto");
        cp.add((Widget)exampleTree, "Examples");
        cp.selectTab(0);
        return cp;
    }

    public Widget createMainPanel() {
        HorizontalSplitPanel mainPanel = new HorizontalSplitPanel();
        mainPanel.add(this.createExamplePanel());
        mainPanel.add(this.createEditorPanel());
        mainPanel.setSplitPosition("15%");
        mainPanel.setSize("100%", "100%");
        return mainPanel;
    }

    public PlaygroundView(Playground controller) {
        this.controller = controller;
        final FlowPanel vp = new FlowPanel();
        vp.add(this.createFeedbackPanel());
        vp.add(this.createLogoPanel());
        vp.add(this.createMainPanel());
        vp.setSize("100%", "100%");
        vp.setHeight(Window.getClientHeight() + "px");
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                vp.setSize(event.getWidth() + "px", event.getHeight() + "px");
            }
        });
        RootPanel.get().add((Widget)vp);
    }

    public void setOriginalSource(String result) {
        if (result == null) {
            this.sourceText.setText("");
        } else {
            this.sourceText.setText(result);
        }
    }

    public void setPolicySource(String result) {
        if (result == null) {
            this.policyText.setText("");
        } else {
            this.policyText.setText(result);
        }
    }

    public void setCajoledSource(String html, String js) {
        if (html == null && js == null) {
            this.cajoledSource.setText("There were cajoling errors");
            return;
        }
        this.cajoledSource.setHTML(this.prettyPrint(html) + "&lt;script&gt;" + this.prettyPrint(js) + "&lt;/script&gt;");
    }

    public void setLoading(boolean isLoading) {
        this.loadingLabel.setVisible(isLoading);
    }

    private native String prettyPrint(String var1);

    private ScriptElement scriptOf(String text) {
        com.google.gwt.user.client.Element el = DOM.createElement((String)"script");
        ScriptElement script = ScriptElement.as((Element)el);
        script.setType("text/javascript");
        script.setInnerText(text);
        return script;
    }

    public void setRenderedResult(String policy, String html, String js) {
        if (html == null && js == null) {
            this.renderPanel.setText("There were cajoling errors");
            return;
        }
        this.renderPanel.setHTML("<div id=\"cajoled-output\">\n" + (html != null ? html : "") + "</div>\n");
        this.selectTab(Tabs.RENDER);
        com.google.gwt.user.client.Element parent = this.renderPanel.getElement();
        parent.appendChild((Node)this.scriptOf(policy));
        parent.appendChild((Node)this.scriptOf("caja___.enable()"));
        if (js != null) {
            parent.appendChild((Node)this.scriptOf(js));
        }
        this.renderResult.setText(this.getRenderResult());
    }

    private native String getRenderResult();

    public void addCompileMessage(String item) {
        this.compileMessages.insertRow(0);
        this.compileMessages.setHTML(0, 0, item);
    }

    public void addRuntimeMessage(String item) {
        this.runtimeMessages.insertRow(0);
        this.runtimeMessages.setText(0, 0, item);
    }

    public void highlightSource(String uri, int start, int sOffset, int end, int eOffset) {
        this.sourceText.setCursorPos(start);
        this.sourceText.setSelectionRange(start, sOffset, end, eOffset);
    }

    public static enum Tabs {
        SOURCE,
        POLICY,
        CAJOLED_SOURCE,
        RENDER,
        COMPILE_WARNINGS,
        RUNTIME_WARNINGS,
        TAMING,
        MANIFEST;

    }
}

