/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryManager;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.View;

@Managed
@ManagedDescription(value="JCR cluster recovery manager")
@NameTemplate(value={@Property(key="service", value="replication"), @Property(key="workspace", value="{WorkspaceName}")})
public class RecoveryManagerManaged {
    private RecoveryManager manager;

    public RecoveryManagerManaged(RecoveryManager manager) {
        this.manager = manager;
    }

    @Managed
    @ManagedDescription(value="The workspace name")
    public String getWorkspaceName() {
        return this.manager.getWorkspaceName();
    }

    @Managed
    @ManagedDescription(value="The workspace name")
    public String getRepositoryName() {
        return this.manager.getRepositoryName();
    }

    @Managed
    @ManagedDescription(value="The active cluster participants")
    public String[] getActiveParticipants() {
        List<String> initedParticipantsClusterList = this.manager.getInitedParticipantsClusterList();
        return initedParticipantsClusterList.toArray(new String[initedParticipantsClusterList.size()]);
    }

    @Managed
    @ManagedDescription(value="The cluster participants")
    public String[] getParticipants() {
        List<String> initedParticipantsClusterList = this.manager.getParticipantsClusterList();
        return initedParticipantsClusterList.toArray(new String[initedParticipantsClusterList.size()]);
    }

    @Managed
    @ManagedDescription(value="Initialization status")
    public boolean isInitializationComplete() {
        return this.manager.isAllInited();
    }

    @Managed
    @ManagedDescription(value="The node name in the cluster")
    public String getNodeName() {
        return this.manager.getOwnName();
    }

    @Managed
    @ManagedDescription(value="The cluster name")
    public String getClusterName() {
        JChannel juliaChannel = this.manager.getChannelManager().getChannel();
        return juliaChannel.getClusterName();
    }

    @Managed
    @ManagedDescription(value="The cluster members")
    public String[] getClusterMembers() {
        JChannel juliaChannel = this.manager.getChannelManager().getChannel();
        View view = juliaChannel.getView();
        ArrayList<String> members = new ArrayList<String>();
        for (Address member : view.getMembers()) {
            members.add(member.toString());
        }
        return members.toArray(new String[members.size()]);
    }
}

