/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;

@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageBody.gtmpl")
public class UIPageBody
extends UIComponentDecorator {
    private UIPortalComponent maximizedUIComponent;
    private String storageId;

    public UIPageBody(PageBody model) throws Exception {
        this.setId("UIPageBody");
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public UIPageBody() throws Exception {
        this.setId("UIPageBody");
    }

    public void init(PageBody model) throws Exception {
        this.setId("UIPageBody");
    }

    public void setPageBody(UserNode pageNode, UIPortal uiPortal) throws Exception {
        PortalRequestContext context = Util.getPortalRequestContext();
        uiPortal.setMaximizedUIComponent(null);
        UIPage uiPage = this.getUIPage(pageNode, uiPortal, context);
        if (uiPage == null) {
            this.setUIComponent(null);
            return;
        }
        if (uiPage.isShowMaxWindow()) {
            uiPortal.setMaximizedUIComponent((UIComponent)uiPage);
        } else {
            Object maximizedComponent = uiPortal.getMaximizedUIComponent();
            if (maximizedComponent != null && maximizedComponent instanceof UIPage) {
                uiPortal.setMaximizedUIComponent(null);
            }
            if ((maximizedComponent = this.getMaximizedUIComponent()) != null && maximizedComponent instanceof UIPage) {
                this.setMaximizedUIComponent(null);
            }
        }
        this.setUIComponent((UIComponent)uiPage);
    }

    private UIPage getUIPage(UserNode pageNode, UIPortal uiPortal, WebuiRequestContext context) throws Exception {
        Page page = null;
        String pageReference = null;
        if (pageNode != null && (pageReference = pageNode.getPageRef()) != null) {
            ExoContainer appContainer = context.getApplication().getApplicationServiceContainer();
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)appContainer.getComponentInstanceOfType(UserPortalConfigService.class);
            page = userPortalConfigService.getPage(pageReference, context.getRemoteUser());
        }
        if (page == null) {
            uiPortal.clearUIPage(pageReference);
            return null;
        }
        UIPage uiPage = uiPortal.getUIPage(pageReference);
        if (uiPage != null) {
            return uiPage;
        }
        UIPageFactory clazz = UIPageFactory.getInstance(page.getFactoryId());
        uiPage = clazz.createUIPage(context);
        PortalDataMapper.toUIPage(uiPage, page);
        uiPortal.setUIPage(pageReference, uiPage);
        return uiPage;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.maximizedUIComponent != null && Util.getUIPortalApplication().getModeState() % 2 == 0) {
            this.maximizedUIComponent.processRender((WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
            return;
        }
        super.processRender(context);
    }

    public UIPortalComponent getMaximizedUIComponent() {
        return this.maximizedUIComponent;
    }

    public void setMaximizedUIComponent(UIPortalComponent uiMaximizedComponent) {
        this.maximizedUIComponent = uiMaximizedComponent;
    }
}

