/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.util.CajaTestCase;

public class ExpressionTest
extends CajaTestCase {
    public final void testConditionResult() throws ParseException {
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("false")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("true")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("0")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("1")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("''")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("'foo'")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("null")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("/foo/")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("foo")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("x.y")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("x[y]")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("-x")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("!1")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("!0")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("!foo")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("[]")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("{}")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("function () {}")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("true && true")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("false && true")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("true && false")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("false && false")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("false && x")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("x && false")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("x && true")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("true || true")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("false || true")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("true || false")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("false || false")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("true || x")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("x || true")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("x || false")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("x,false")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("x,true")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("x,y")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("x ? false : 0")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("0 ? x : 0")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("1 ? false : x")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("x ? true : 1")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("0 ? x : 1")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("1 ? true : x")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("1 ? x : 0")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("0 ? false : x")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("1 ? x : 1")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("0 ? true : x")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("x ? true : y")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("x ? false : y")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("x ? y : true")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("x ? y : false")).conditionResult());
        ExpressionTest.assertFalse((boolean)this.jsExpr(this.fromString("void true")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("new Boolean")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("new Boolean(false)")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("new Date")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("new Date()")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("new RegExp('')")).conditionResult());
        ExpressionTest.assertTrue((boolean)this.jsExpr(this.fromString("new String('')")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("Date")).conditionResult());
        ExpressionTest.assertNull((Object)this.jsExpr(this.fromString("Date()")).conditionResult());
    }

    public final void testSimplifyForSideEffect() throws ParseException {
        this.assertSimplified(null, "1");
        this.assertSimplified(null, "0");
        this.assertSimplified(null, "void 1");
        this.assertSimplified(null, "void 0");
        this.assertSimplified("foo()", "foo(), 1");
        this.assertSimplified("foo()", "1, foo()");
        this.assertSimplified(null, "1, 2");
        this.assertSimplified("foo()", "foo() || 1");
        this.assertSimplified("foo()", "1 || foo()");
        this.assertSimplified(null, "1 || 2");
        this.assertSimplified("foo()", "foo() && 1");
        this.assertSimplified("foo()", "1 && foo()");
        this.assertSimplified(null, "1 && 2");
        this.assertSimplified("++x", "++x");
        this.assertSimplified("++x", "x++");
        this.assertSimplified("--x", "--x");
        this.assertSimplified("--x", "x--");
        this.assertSimplified("x -= 2", "x -= 2");
        this.assertSimplified("x = 2", "x = 2");
        this.assertSimplified("x + y", "x + y");
    }

    public final void testTypeOf() throws Exception {
        this.assertTypeOf("boolean", "true");
        this.assertTypeOf("boolean", "false");
        this.assertTypeOf("number", "0");
        this.assertTypeOf("number", "1");
        this.assertTypeOf("number", "-1.5");
        this.assertTypeOf("number", "6.02e+23");
        this.assertTypeOf("string", "''");
        this.assertTypeOf("string", "'foo'");
        this.assertTypeOf("object", "null");
        this.assertTypeOf("object", "{}");
        this.assertTypeOf("function", "function () {}");
        this.assertTypeOf("boolean", "!x");
        this.assertTypeOf("boolean", "!x || !y");
        this.assertTypeOf(null, "!x || y");
        this.assertTypeOf(null, "x || !y");
        this.assertTypeOf("number", "+x");
        this.assertTypeOf("number", "-x");
        this.assertTypeOf("number", "x - y");
        this.assertTypeOf(null, "y++");
        this.assertTypeOf(null, "z--");
        this.assertTypeOf("number", "++y");
        this.assertTypeOf("number", "--z");
        this.assertTypeOf(null, "a + b");
        this.assertTypeOf("number", "+a + 1");
        this.assertTypeOf("string", "'' + b");
        this.assertTypeOf("number", "'4' - 1");
        this.assertTypeOf("string", "foo() ? 'bar' : 'baz'");
        this.assertTypeOf(null, "foo() ? 'bar' : null");
        this.assertTypeOf(null, "foo() ? bar : 'baz'");
        this.assertTypeOf("string", "'bar' && ('' + baz)");
        this.assertTypeOf(null, "'bar' && null");
        this.assertTypeOf(null, "bar && 'baz'");
        this.assertTypeOf("boolean", "foo(), !x");
        this.assertTypeOf(null, "'' + foo(), x");
        this.assertTypeOf(null, "/./");
    }

    public final void testFold() throws Exception {
        this.assertFolded("4.0", "1 + 3");
        this.assertFolded("'13'", "1 + '3'");
        this.assertFolded("'13'", "'1' + 3");
        this.assertFolded("'13'", "'1' + '3'");
        this.assertFolded("'-1.5'", "'' + -1.5");
        this.assertFolded("'undefined'", "'' + void 0");
        this.assertFolded("'null'", "null + ''");
        this.assertFolded("null + 0", "null + 0");
        this.assertFolded("-2.0", "1 - 3");
        this.assertFolded("4.0", "2 * 2");
        this.assertFolded("true", "!''");
        this.assertFolded("true", "!0");
        this.assertFolded("false", "!'0'");
        this.assertFolded("true", "!null");
        this.assertFolded("true", "!(void 0)");
        this.assertFolded("!void foo()", "!(void foo())");
        this.assertFolded("false", "!(4,true)");
        this.assertFolded("! (foo() || true)", "!(foo()||true)");
        this.assertFolded("false", "false && foo()");
        this.assertFolded("true", "true || foo()");
        this.assertFolded("foo()", "false || foo()");
        this.assertFolded("foo()", "true && foo()");
        this.assertFolded("foo != bar", "foo != bar && true");
        this.assertFolded("foo != bar", "foo != bar || false");
        this.assertFolded("foo() && true", "foo() && true");
        this.assertFolded("foo() || false", "foo() || false");
        this.assertFolded("true", "'foo' == 'foo'");
        this.assertFolded("true", "'foo' === 'foo'");
        this.assertFolded("false", "'foo' == 'bar'");
        this.assertFolded("false", "'foo' === 'bar'");
        this.assertFolded("false", "4 === '4'");
        this.assertFolded("4 == '4'", "4 == '4'");
        this.assertFolded("false", "'foo' != 'foo'");
        this.assertFolded("false", "'foo' !== 'foo'");
        this.assertFolded("true", "'foo' != 'bar'");
        this.assertFolded("true", "'foo' !== 'bar'");
        this.assertFolded("true", "4 !== '4'");
        this.assertFolded("4 != '4'", "4 != '4'");
        this.assertFolded("a !== b", "!(a === b)");
        this.assertFolded("a === b", "!(a !== b)");
        this.assertFolded("a != b", "!(a == b)");
        this.assertFolded("a == b", "!(a != b)");
        this.assertFolded("0.5", "1 / 2");
        this.assertFolded("1 / '2'", "1 / '2'");
        this.assertFolded("(1/0)", "1 / 0");
        this.assertFolded("(-1/0)", "-1 / 0");
        this.assertFolded("(0/0)", "0 / 0");
        this.assertFolded("1.0", "1 % 3");
        this.assertFolded("1.0", "1 % -3");
        this.assertFolded("-1.0", "-1 % 3");
        this.assertFolded("1.0", "1 % -3");
        this.assertFolded("-1.0", "-1 % 3");
        this.assertFolded("-1.0", "-1 % -3");
        this.assertFolded("2147483647", "0x7fffffff | 0");
        this.assertFolded("-2147483647", "-0x7fffffff | 0");
        this.assertFolded("-2147483648", "0x80000000 | 0");
        this.assertFolded("-1", "0xffffffff | 0");
        this.assertFolded("-1", "0x1ffffffff | 0");
        this.assertFolded("0", "0x100000000 | 0");
        this.assertFolded("0", "0x200000000 | 0");
        this.assertFolded("1", "0x100000001 | 0");
        this.assertFolded("1661992960", "1e20 | 0");
        this.assertFolded("-1661992960", "-1e20 | 0");
        this.assertFolded("1024", "1 << 10");
        this.assertFolded("1048576", "1 << 20");
        this.assertFolded("1", "1 << 0/0");
        this.assertFolded("0", "0/0 << 0");
        this.assertFolded("1", "1 << 1/0");
        this.assertFolded("0", "1/0 << 0");
        this.assertFolded("2", "4 >> 1");
        this.assertFolded("1", "4 >> 2");
        this.assertFolded("0", "4 >> 3");
        this.assertFolded("-1", "-1 >> 1");
        this.assertFolded("1", "1 >> 1/0");
        this.assertFolded("0", "1/0 >> 0");
        this.assertFolded("2147483647", "-1 >>> 1");
        this.assertFolded("1", "4 >>> 2");
        this.assertFolded("1", "1 >>> 1/0");
        this.assertFolded("0", "1/0 >>> 0");
        this.assertFolded("0", "1 & 2");
        this.assertFolded("2", "2 & 3");
        this.assertFolded("2", "3 & 2");
        this.assertFolded("0", "1 & 1/0");
        this.assertFolded("0", "1/0 & 0");
        this.assertFolded("3", "1 | 2");
        this.assertFolded("7", "6 | 5");
        this.assertFolded("11", "3 | 9");
        this.assertFolded("1", "1 | 1/0");
        this.assertFolded("0", "1/0 | 0");
        this.assertFolded("0", "0 ^ 0");
        this.assertFolded("0", "1 ^ 1");
        this.assertFolded("3", "1 ^ 2");
        this.assertFolded("-2", "-1 ^ 1");
        this.assertFolded("1", "1 ^ 1/0");
        this.assertFolded("0", "1/0 ^ 0");
        this.assertFolded("4.0", "4.0");
        this.assertFolded("4.0", "+4.0");
        this.assertFolded("-1", "~0");
        this.assertFolded("-1", "-1");
        this.assertFolded("(-0)", "-0");
        this.assertFolded("0.0", "-(-0)");
        this.assertFolded("3", "'foo'.length");
        this.assertFolded("1", "'foo'.indexOf('o')");
        this.assertFolded("-1", "'foo'.indexOf('bar')");
        this.assertFolded("foo.bar", "foo['bar']");
        this.assertFolded("foo[ 0 ]", "foo[0]");
        this.assertFolded("foo[ '0' ]", "foo['0']");
        this.assertFolded("foo[ 'null' ]", "foo['null']");
        this.assertFolded("3", "'foo'['length']");
        this.assertFolded("new Date", "new Date()");
        this.assertFolded("new Date(0)", "new Date(0)");
        this.assertFolded("(function () { return this; })()", "(function () { return this; })()");
        this.assertFolded("(function () {\n   return -arguments[ i ];\n })()", "(function () { return -arguments[i]; })()");
        this.assertFolded("4", "(function () { return 4; })()");
        this.assertFolded("void 0", "(function () {})()");
        this.assertFolded("void 0", "(function () { return; })()");
        this.assertFolded("void foo()", "(function () { foo(); })()");
        this.assertFolded("(function (i) { return i; })()", "(function (i) { return i; })()");
        this.assertFolded("(function i() { return i; })()", "(function i() { return i; })()");
        this.assertFolded("(function () {\n   arguments.callee();\n })()", "(function () { arguments.callee(); })()");
        this.assertFolded("eval", "0,eval", false);
        this.assertFolded("0, eval", "0,eval", true);
        this.assertFolded("foo.bar", "0,foo.bar", false);
        this.assertFolded("0, foo.bar", "0,foo.bar", true);
        this.assertFolded("foo[ bar ]", "0,foo[bar]", false);
        this.assertFolded("0, foo[ bar ]", "0,foo[bar]", true);
        this.assertFolded("foo[ 'bar' ]", "0,foo['bar']", false);
        this.assertFolded("0, foo[ 'bar' ]", "0,foo['bar']", true);
    }

    public final void testToInt32() {
        ExpressionTest.assertEquals((long)0L, (long)Operation.toInt32(0.0));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toInt32(-0.0));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toInt32(Double.POSITIVE_INFINITY));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toInt32(Double.NEGATIVE_INFINITY));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toInt32(Double.NaN));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toInt32(4.294967296E9));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toInt32(-4.294967296E9));
        ExpressionTest.assertEquals((long)Integer.MAX_VALUE, (long)Operation.toInt32(2.147483647E9));
        ExpressionTest.assertEquals((long)-2147483647L, (long)Operation.toInt32(-2.147483647E9));
        ExpressionTest.assertEquals((long)Integer.MIN_VALUE, (long)Operation.toInt32(-2.147483648E9));
        ExpressionTest.assertEquals((long)Integer.MIN_VALUE, (long)Operation.toInt32(2.147483648E9));
        ExpressionTest.assertEquals((long)1L, (long)Operation.toInt32(1.0));
        ExpressionTest.assertEquals((long)-1L, (long)Operation.toInt32(-1.0));
        ExpressionTest.assertEquals((long)2L, (long)Operation.toInt32(2.0));
        ExpressionTest.assertEquals((long)-2L, (long)Operation.toInt32(-2.0));
        ExpressionTest.assertEquals((long)1000000L, (long)Operation.toInt32(1000000.0));
        ExpressionTest.assertEquals((long)10000000L, (long)Operation.toInt32(1.0E7));
        ExpressionTest.assertEquals((long)100000000L, (long)Operation.toInt32(1.0E8));
        ExpressionTest.assertEquals((long)1000000000L, (long)Operation.toInt32(1.0E9));
        ExpressionTest.assertEquals((long)1410065408L, (long)Operation.toInt32(1.0E10));
        ExpressionTest.assertEquals((long)1215752192L, (long)Operation.toInt32(1.0E11));
        ExpressionTest.assertEquals((long)-727379968L, (long)Operation.toInt32(1.0E12));
        ExpressionTest.assertEquals((long)-1000000L, (long)Operation.toInt32(-1000000.0));
        ExpressionTest.assertEquals((long)-10000000L, (long)Operation.toInt32(-1.0E7));
        ExpressionTest.assertEquals((long)-100000000L, (long)Operation.toInt32(-1.0E8));
        ExpressionTest.assertEquals((long)-1000000000L, (long)Operation.toInt32(-1.0E9));
        ExpressionTest.assertEquals((long)-1410065408L, (long)Operation.toInt32(-1.0E10));
        ExpressionTest.assertEquals((long)-1215752192L, (long)Operation.toInt32(-1.0E11));
        ExpressionTest.assertEquals((long)727379968L, (long)Operation.toInt32(-1.0E12));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toInt32(0.5));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toInt32(-0.5));
        ExpressionTest.assertEquals((long)1L, (long)Operation.toInt32(1.5));
        ExpressionTest.assertEquals((long)-1L, (long)Operation.toInt32(-1.5));
    }

    public final void testToUint32() {
        ExpressionTest.assertEquals((long)0L, (long)Operation.toUint32(0.0));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toUint32(-0.0));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toUint32(Double.POSITIVE_INFINITY));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toUint32(Double.NEGATIVE_INFINITY));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toUint32(Double.NaN));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toUint32(4.294967296E9));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toUint32(-4.294967296E9));
        ExpressionTest.assertEquals((long)Integer.MAX_VALUE, (long)Operation.toUint32(2.147483647E9));
        ExpressionTest.assertEquals((long)0x80000001L, (long)Operation.toUint32(-2.147483647E9));
        ExpressionTest.assertEquals((long)0x80000000L, (long)Operation.toUint32(-2.147483648E9));
        ExpressionTest.assertEquals((long)0x80000000L, (long)Operation.toUint32(2.147483648E9));
        ExpressionTest.assertEquals((long)1L, (long)Operation.toUint32(1.0));
        ExpressionTest.assertEquals((long)0xFFFFFFFFL, (long)Operation.toUint32(-1.0));
        ExpressionTest.assertEquals((long)2L, (long)Operation.toUint32(2.0));
        ExpressionTest.assertEquals((long)0xFFFFFFFEL, (long)Operation.toUint32(-2.0));
        ExpressionTest.assertEquals((long)1000000L, (long)Operation.toUint32(1000000.0));
        ExpressionTest.assertEquals((long)10000000L, (long)Operation.toUint32(1.0E7));
        ExpressionTest.assertEquals((long)100000000L, (long)Operation.toUint32(1.0E8));
        ExpressionTest.assertEquals((long)1000000000L, (long)Operation.toUint32(1.0E9));
        ExpressionTest.assertEquals((long)1410065408L, (long)Operation.toUint32(1.0E10));
        ExpressionTest.assertEquals((long)1215752192L, (long)Operation.toUint32(1.0E11));
        ExpressionTest.assertEquals((long)3567587328L, (long)Operation.toUint32(1.0E12));
        ExpressionTest.assertEquals((long)4293967296L, (long)Operation.toUint32(-1000000.0));
        ExpressionTest.assertEquals((long)4284967296L, (long)Operation.toUint32(-1.0E7));
        ExpressionTest.assertEquals((long)4194967296L, (long)Operation.toUint32(-1.0E8));
        ExpressionTest.assertEquals((long)3294967296L, (long)Operation.toUint32(-1.0E9));
        ExpressionTest.assertEquals((long)2884901888L, (long)Operation.toUint32(-1.0E10));
        ExpressionTest.assertEquals((long)3079215104L, (long)Operation.toUint32(-1.0E11));
        ExpressionTest.assertEquals((long)727379968L, (long)Operation.toUint32(-1.0E12));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toUint32(0.5));
        ExpressionTest.assertEquals((long)0L, (long)Operation.toUint32(-0.5));
        ExpressionTest.assertEquals((long)1L, (long)Operation.toUint32(1.5));
        ExpressionTest.assertEquals((long)0xFFFFFFFFL, (long)Operation.toUint32(-1.5));
    }

    private void assertSimplified(String golden, String input) throws ParseException {
        Expression simple = this.jsExpr(this.fromString(input)).simplifyForSideEffect();
        if (golden == null) {
            ExpressionTest.assertNull((String)input, (Object)simple);
            return;
        }
        ExpressionTest.assertEquals((String)input, (String)ExpressionTest.render(this.jsExpr(this.fromString(golden))), (String)ExpressionTest.render(simple));
    }

    private void assertTypeOf(String type, String expr) throws ParseException {
        ExpressionTest.assertEquals((String)type, (String)this.jsExpr(this.fromString(expr)).typeOf());
    }

    private void assertFolded(String result, String expr) throws ParseException {
        this.assertFolded(result, expr, false);
    }

    private void assertFolded(String result, String expr, boolean isFn) throws ParseException {
        Expression actual;
        Expression input = this.jsExpr(this.fromString(expr));
        if (input instanceof Operation) {
            Operation op = (Operation)input;
            for (Expression expression : op.children()) {
                if (!Operation.is((ParseTreeNode)expression, Operator.NEGATION) && !Operation.is((ParseTreeNode)expression, Operator.DIVISION) || !(expression.children().get(0) instanceof NumberLiteral)) continue;
                op.replaceChild(expression.fold(false), expression);
            }
        }
        ExpressionTest.assertEquals((String)expr, (String)result, (String)((actual = input.fold(isFn)) != null ? ExpressionTest.render(actual) : null));
    }
}

