/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.common.collection.AbstractFilterIterator;
import org.chromattic.core.jcr.AbstractLinkManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathLinkManager
extends AbstractLinkManager {
    public PathLinkManager(Session session) {
        super(session);
    }

    @Override
    protected Node _getReferenced(Property property) throws RepositoryException {
        int type = property.getType();
        if (type == 8) {
            String path = property.getString();
            try {
                return (Node)this.session.getItem(path);
            }
            catch (PathNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected void _setReferenced(Node referent, String propertyName, Node referenced) throws RepositoryException {
        if (referenced != null) {
            String path = referenced.getPath();
            ValueFactory valueFactory = this.session.getValueFactory();
            Value value = valueFactory.createValue(path, 8);
            referent.setProperty(propertyName, value);
        } else {
            referent.setProperty(propertyName, (String)null);
        }
    }

    @Override
    protected Iterator<Node> _getReferents(Node referenced, String propertyName) throws RepositoryException {
        String path = referenced.getPath();
        QueryManager queryMgr = this.session.getWorkspace().getQueryManager();
        Query query = queryMgr.createQuery("SELECT * FROM nt:base WHERE " + propertyName + "='" + path + "'", "sql");
        QueryResult result = query.execute();
        NodeIterator nodes = result.getNodes();
        return new AbstractFilterIterator<Node, Node>((Iterator)nodes){
            private Node current;

            protected Node adapt(Node node) {
                this.current = node;
                return node;
            }

            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                try {
                    this.current.remove();
                }
                catch (RepositoryException e) {
                    throw new UndeclaredRepositoryException(e);
                }
            }
        };
    }
}

