/**
 * Copyright (C) 2009 eXo Platform SAS.
 * 
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.exoplatform.webui.form.validator;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import java.util.regex.Pattern;

/**
 * Created by The eXo Platform SARL
 * Author : Le Bien Thuy
 *          lebienthuy@gmail.com
 * Oct 10, 2007
 * 
 * Validates whether this value matches one regular expression.
 */
@Serialized
public class ExpressionValidator implements Validator
{
   private Pattern pattern;

   private String key_;

   // For @Serialized needs
   public ExpressionValidator()
   {
   }

   public ExpressionValidator(final String regex)
   {
      pattern = Pattern.compile(regex);
      key_ = "ExpressionValidator.msg.value-invalid";
   }

   public ExpressionValidator(final String regex, final String key)
   {
      pattern = Pattern.compile(regex);
      key_ = key;
   }

   public void validate(final UIFormInput uiInput) throws Exception
   {
      if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0)
      {
         return;
      }
      if (uiInput.getValue() != null)
      {
         String value = ((String)uiInput.getValue()).trim();
         if (pattern.matcher(value).find())
         {
            return;
         }
      }

      //  modified by Pham Dinh Tan
      UIComponent uiComponent = (UIComponent)uiInput;
      UIForm uiForm = uiComponent.getAncestorOfType(UIForm.class);
      String label;
      try
      {
    	  label = uiForm.getId() + ".label." + uiInput.getName();
      }
      catch (Exception e)
      {
         label = uiInput.getName();
      }
      Object[] args = {label};
      throw new MessageException(new ApplicationMessage(key_, args, ApplicationMessage.WARNING));
   }
}
