/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dashboard.webui.component;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.dashboard.webui.component.UIDashboard;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.StaleModelException;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Dashboard;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.webui.application.UIGadget;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.application.AbstractApplicationMessage;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.Param;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

@ComponentConfig(template="classpath:groovy/dashboard/webui/component/UIDashboardContainer.gtmpl", initParams={@ParamConfig(name="ContainerConfigs", value="classpath:conf/uiconf/dashboard/webui/container/ContainerConfig.groovy")})
public class UIDashboardContainer
extends org.exoplatform.webui.core.UIContainer {
    public static final int MAX_COLUMN = 4;
    public static final String COLUMN_CONTAINER = "column";
    public static final String ROW_CONTAINER = "row";
    public static final String ROOT_CONTAINER = "dashboard";
    private List<SelectItemOption<String>> containerOptions;
    private String windowId;
    private String containerTemplate = null;
    public static final String COLINDEX = "colIndex";
    public static final String ROWINDEX = "rowIndex";
    public static String SAVE_FAIL = "UIDashboardContainer.saveFail";

    public UIDashboardContainer(InitParams initParams) throws Exception {
        if (initParams == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        this.windowId = ((PortletRequestContext)context).getRequest().getWindowID();
        Param param = initParams.getParam("ContainerConfigs");
        this.containerOptions = (List)param.getMapGroovyObject(context);
        if (this.containerOptions == null) {
            return;
        }
        UIContainer uicontainer = (UIContainer)this.addChild(UIContainer.class, null, null);
        Container container = this.createContainer(COLUMN_CONTAINER, null);
        PortalDataMapper.toUIContainer((UIContainer)uicontainer, (Container)container);
        this.setColumns(3);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        DataStorage service = (DataStorage)this.getApplicationComponent(DataStorage.class);
        UIPortlet currentUIPortlet = UIPortlet.getCurrentUIPortlet();
        Dashboard dashboard = null;
        if (currentUIPortlet.getStorageId() != null) {
            dashboard = service.loadDashboard(currentUIPortlet.getStorageId());
        }
        if (dashboard != null) {
            UIContainer uiRoot = (UIContainer)this.getChild(UIContainer.class);
            uiRoot.getChildren().clear();
            PortalDataMapper.toUIContainer((UIContainer)uiRoot, (Container)dashboard);
        }
        super.processRender(context);
    }

    public void addUIGadget(UIGadget gadget, int col, int row) {
        UIContainer uiContainer = this.getColumn(col);
        List children = uiContainer.getChildren();
        if (uiContainer == null || row < 0 || row > children.size()) {
            return;
        }
        gadget.setParent((UIComponent)uiContainer);
        children.add(row, gadget);
    }

    public UIGadget getUIGadget(int col, int row) {
        UIContainer uiContainer = this.getColumn(col);
        if (uiContainer == null || row < 0 || row >= uiContainer.getChildren().size()) {
            return null;
        }
        return (UIGadget)uiContainer.getChild(row);
    }

    public UIGadget getUIGadget(String gadgetId) {
        List<UIContainer> columns = this.getColumns();
        for (int iCol = 0; iCol < this.getColumns().size(); ++iCol) {
            for (int iRow = 0; iRow < columns.get(iCol).getChildren().size(); ++iRow) {
                UIGadget gadget = (UIGadget)columns.get(iCol).getChild(iRow);
                if (!gadgetId.equals(gadget.getId())) continue;
                return gadget;
            }
        }
        return null;
    }

    public UIGadget removeUIGadget(String gadgetId) {
        UIGadget gadget = this.getUIGadget(gadgetId);
        if (gadget != null) {
            UIContainer uiContainer = (UIContainer)gadget.getParent();
            gadget.setParent(null);
            uiContainer.getChildren().remove(gadget);
        }
        return gadget;
    }

    public UIGadget removeUIGadget(int col, int row) {
        UIGadget gadget = this.getUIGadget(col, row);
        if (gadget != null) {
            this.removeUIGadget(gadget.getId());
        }
        return gadget;
    }

    public void moveUIGadget(String gadgetId, int col, int row) {
        UIGadget gadget = this.removeUIGadget(gadgetId);
        if (gadget == null) {
            return;
        }
        this.addUIGadget(gadget, col, row);
    }

    public UIContainer getColumn(int col) {
        if (col < 0 || col > this.getColumns().size()) {
            return null;
        }
        return this.getColumns().get(col);
    }

    public boolean hasUIGadget() {
        UIGadget gadget = (UIGadget)this.findFirstComponentOfType(UIGadget.class);
        return gadget != null;
    }

    public UIDashboardContainer setColumns(int num) throws Exception {
        if (num < 1 || num > 4) {
            return null;
        }
        UIContainer uiRoot = (UIContainer)this.findFirstComponentOfType(UIContainer.class);
        List<UIContainer> columns = this.getColumns();
        int colSize = columns.size();
        if (num < colSize) {
            for (int i = num; i < colSize; ++i) {
                UIContainer tempCol = columns.get(i);
                ArrayList<UIComponent> components = new ArrayList<UIComponent>();
                for (UIComponent component : tempCol.getChildren()) {
                    columns.get(num - 1).addChild(component);
                    components.add(component);
                }
                uiRoot.removeChildById(tempCol.getId());
                for (UIComponent component : components) {
                    component.setParent((UIComponent)columns.get(num - 1));
                }
            }
        } else if (num > colSize) {
            do {
                UIContainer uiContainer = (UIContainer)this.createUIComponent(UIContainer.class, null, null);
                PortalDataMapper.toUIContainer((UIContainer)uiContainer, (Container)this.createContainer(ROW_CONTAINER, "UIColumn-" + colSize));
                uiRoot.addChild((UIComponent)uiContainer);
            } while (num > ++colSize);
        }
        return this;
    }

    public List<UIContainer> getColumns() {
        ArrayList<UIContainer> list = new ArrayList<UIContainer>();
        UIContainer uiRoot = (UIContainer)this.findFirstComponentOfType(UIContainer.class);
        uiRoot.findComponentOfType(list, UIContainer.class);
        if (list.size() > 0 && list.contains(uiRoot)) {
            list.remove(uiRoot);
        }
        return list;
    }

    public Container createContainer(String type, String id) throws Exception {
        for (SelectItemOption<String> item : this.containerOptions) {
            if (!item.getLabel().equals(type)) continue;
            Container container = this.toContainer((String)item.getValue());
            if (id != null) {
                container.setId(id);
            }
            return container;
        }
        return null;
    }

    private Container toContainer(String xml) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        IBindingFactory bfact = BindingDirectory.getFactory(Container.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return (Container)uctx.unmarshalDocument((InputStream)is, null);
    }

    public String getWindowId() {
        return this.windowId;
    }

    public void setContainerTemplate(String template) {
        this.containerTemplate = template;
    }

    public String getContainerTemplate() {
        return this.containerTemplate;
    }

    public void save() throws Exception {
        UIContainer uiRoot = (UIContainer)this.findFirstComponentOfType(UIContainer.class);
        if (!((UIDashboard)this.getParent()).canEdit()) {
            return;
        }
        UIPortlet currentUIPortlet = UIPortlet.getCurrentUIPortlet();
        if (currentUIPortlet.getStorageId() != null) {
            Dashboard dashboard = new Dashboard(currentUIPortlet.getStorageId());
            PortalDataMapper.toContainer((Container)dashboard, (UIContainer)uiRoot);
            DataStorage service = (DataStorage)this.getApplicationComponent(DataStorage.class);
            try {
                service.saveDashboard(dashboard);
            }
            catch (StaleModelException e) {
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                context.getUIApplication().addMessage((AbstractApplicationMessage)new ApplicationMessage("UIDashboard.msg.StaleData", null, 0));
                context.setAttribute(SAVE_FAIL, (Object)true);
            }
        }
    }

    public static class DeleteGadgetActionListener
    extends EventListener<UIDashboard> {
        public final void execute(Event<UIDashboard> event) throws Exception {
            UIDashboard uiDashboard = (UIDashboard)((Object)event.getSource());
            if (!uiDashboard.canEdit()) {
                return;
            }
            WebuiRequestContext context = event.getRequestContext();
            String objectId = context.getRequestParameter("objectId");
            UIDashboardContainer uiDashboardContainer = (UIDashboardContainer)uiDashboard.getChild(UIDashboardContainer.class);
            uiDashboardContainer.removeUIGadget(objectId);
            boolean isMaximized = false;
            if (uiDashboard.getMaximizedGadget() != null && uiDashboard.getMaximizedGadget().getId().equals(objectId)) {
                uiDashboard.setMaximizedGadget(null);
                isMaximized = true;
            }
            uiDashboardContainer.save();
            if (!isMaximized && context.getAttribute(SAVE_FAIL) == null) {
                Util.getPortalRequestContext().setResponseComplete(true);
            }
        }
    }

    public static class MoveGadgetActionListener
    extends EventListener<UIDashboard> {
        public final void execute(Event<UIDashboard> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIDashboard uiDashboard = (UIDashboard)((Object)event.getSource());
            if (!uiDashboard.canEdit()) {
                return;
            }
            UIDashboardContainer uiDashboardContainer = (UIDashboardContainer)uiDashboard.getChild(UIDashboardContainer.class);
            int col = Integer.parseInt(context.getRequestParameter(UIDashboardContainer.COLINDEX));
            int row = Integer.parseInt(context.getRequestParameter(UIDashboardContainer.ROWINDEX));
            String objectId = context.getRequestParameter("objectId");
            uiDashboardContainer.moveUIGadget(objectId, col, row);
            uiDashboardContainer.save();
            if (context.getAttribute(SAVE_FAIL) != null) {
                return;
            }
            Util.getPortalRequestContext().setResponseComplete(true);
        }
    }

    public static class AddNewGadgetActionListener
    extends EventListener<UIDashboard> {
        public final void execute(Event<UIDashboard> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIDashboard uiDashboard = (UIDashboard)((Object)event.getSource());
            if (!uiDashboard.canEdit()) {
                return;
            }
            int col = Integer.parseInt(context.getRequestParameter(UIDashboardContainer.COLINDEX));
            int row = Integer.parseInt(context.getRequestParameter(UIDashboardContainer.ROWINDEX));
            String objectId = context.getRequestParameter("objectId");
            ApplicationRegistryService service = (ApplicationRegistryService)uiDashboard.getApplicationComponent(ApplicationRegistryService.class);
            Application application = service.getApplication(objectId);
            if (application == null) {
                UIApplication uiApplication = context.getUIApplication();
                uiApplication.addMessage((AbstractApplicationMessage)new ApplicationMessage("UIDashboard.msg.ApplicationNotExisted", null));
                context.setAttribute(UIDashboard.APP_NOT_EXIST, (Object)true);
                return;
            }
            UIGadget uiGadget = (UIGadget)((UIDashboard)((Object)event.getSource())).createUIComponent(context, UIGadget.class, null, null);
            uiGadget.setState((ApplicationState)new TransientApplicationState(application.getApplicationName()));
            UIDashboardContainer uiDashboardContainer = (UIDashboardContainer)uiDashboard.getChild(UIDashboardContainer.class);
            uiDashboardContainer.addUIGadget(uiGadget, col, row);
            uiDashboardContainer.save();
            context.addUIComponentToUpdateByAjax((UIComponent)uiDashboardContainer);
        }
    }
}

