/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.command.handler;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.UserWidgetStorage;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.command.Command;

public class WelcomeWidgetHandler
extends Command {
    private String uploadId;

    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        try {
            PortalContainer container = PortalContainer.getInstance();
            UploadService uploadService = (UploadService)container.getComponentInstanceOfType(UploadService.class);
            UploadResource upResource = uploadService.getUploadResource(this.uploadId);
            if (upResource == null) {
                return;
            }
            String instantId = "avatar";
            String widgetType = "WelcomeWidget";
            String userName = req.getRemoteUser();
            UserWidgetStorage service = (UserWidgetStorage)container.getComponentInstanceOfType(UserWidgetStorage.class);
            File file = new File(upResource.getStoreLocation());
            FileInputStream inputStream = new FileInputStream(file);
            FileChannel fchan = inputStream.getChannel();
            long fsize = fchan.size();
            ByteBuffer buff = ByteBuffer.allocate((int)fsize);
            fchan.read(buff);
            buff.rewind();
            byte[] data = buff.array();
            service.save(userName, widgetType, instantId, (Object)data);
            buff.clear();
            fchan.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

