/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.command.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Gadgets;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.command.Command;

public class GetGadgetContainerHandler
extends Command {
    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        PrintWriter writer = res.getWriter();
        try {
            ((Writer)writer).append(this.getGadgetContainers(req));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    private StringBuilder getGadgetContainers(HttpServletRequest req) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DataStorage dataService = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        String userGadgetsId = "user::" + req.getRemoteUser();
        StringBuilder value = new StringBuilder();
        value.append("{\"gadgetContainers\": [\n");
        Gadgets gadgets = dataService.getGadgets(userGadgetsId);
        if (gadgets != null) {
            ArrayList gadgetContainers = gadgets.getChildren();
            for (int i = 0; i < gadgetContainers.size(); ++i) {
                value.append(" {");
                value.append("\n          \"cId\": \"").append(((Container)gadgetContainers.get(i)).getId()).append("\",");
                value.append("\n          \"cName\": \"").append(((Container)gadgetContainers.get(i)).getName()).append("\",");
                value.append("\n          \"cDescription\": \"").append(((Container)gadgetContainers.get(i)).getDescription()).append("\"\n");
                value.append("      }");
                if (i < gadgetContainers.size() - 1) {
                    value.append(",\n");
                    continue;
                }
                value.append("\n");
            }
        }
        value.append("]}\n");
        return value;
    }
}

