/**
 * Copyright (C) 2009 eXo Platform SAS.
 * 
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.exoplatform.webui.organization;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.portal.Constants;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/**
 * Created by The eXo Platform SARL Author : Dang Van Minh minhdv81@yahoo.com
 * Jun 28, 2006
 */
@ComponentConfig(template = "system:/groovy/webui/form/UIVTabInputSet.gtmpl")
@Serialized
public class UIUserProfileInputSet extends UIFormInputSet
{

   private String user_;

   public final static String MALE = "male";

   public final static String FEMALE = "female";

   public UIUserProfileInputSet()
   {
   }

   public UIUserProfileInputSet(String name) throws Exception
   {
      super(name);
      setComponentConfig(UIUserProfileInputSet.class, null);

      UIFormInputSet personalInputSet = new UIFormInputSet("Profile");
      addInput(personalInputSet, UserProfile.PERSONAL_INFO_KEYS);
      addUIFormInput(personalInputSet);

      UIFormInputSet homeInputSet = new UIFormInputSet("HomeInfo");
      addInput(homeInputSet, UserProfile.HOME_INFO_KEYS);
      homeInputSet.setRendered(false);
      addUIFormInput(homeInputSet);

      UIFormInputSet businessInputSet = new UIFormInputSet("BusinessInfo");
      addInput(businessInputSet, UserProfile.BUSINESE_INFO_KEYS);
      businessInputSet.setRendered(false);
      addUIFormInput(businessInputSet);
   }

   public void reset()
   {
      for (UIComponent uiChild : getChildren())
      {
         if (uiChild instanceof UIFormInputSet || uiChild instanceof UIFormInput)
         {
            ((UIFormInputSet)uiChild).reset();
         }
      }
   }

   private void addInput(UIFormInputSet set, String[] keys)
   {

      for (String key : keys)
      {
         if (key.equalsIgnoreCase("user.gender"))
         {
            List<SelectItemOption<String>> ls = new ArrayList<SelectItemOption<String>>();
            ls.add(new SelectItemOption<String>(MALE, MALE));
            ls.add(new SelectItemOption<String>(FEMALE, FEMALE));;
            UIFormSelectBox genderSelectBox = new UIFormSelectBox(key, key, ls);
            set.addUIFormInput(genderSelectBox);
            continue;
         }
         else if (key.equalsIgnoreCase(Constants.USER_LANGUAGE))
         {
            UIFormSelectBox langSelectBox = new UIFormSelectBox(key, key, null);
            set.addUIFormInput(langSelectBox);
            initLanguageCombo(langSelectBox);
            continue;
         }
         set.addUIFormInput(new UIFormStringInput(key, null, null));
      }
   }

   /**
    * Update language select box
    */
   @Override
   public void processRender(WebuiRequestContext context) throws Exception
   {
      UIFormSelectBox langSelectBox = this.findComponentById(Constants.USER_LANGUAGE);
      initLanguageCombo(langSelectBox);
      super.processRender(context);
   }

   private void initLanguageCombo(UIFormSelectBox langSelectBox)
   {
      if (langSelectBox == null)
         return;
      String selectedLang = langSelectBox.getSelectedValues()[0];

      List<SelectItemOption<String>> lang = new ArrayList<SelectItemOption<String>>();
      langSelectBox.setOptions(lang); // Clear

      LocaleConfigService localeService = getApplicationComponent(LocaleConfigService.class);
      Locale currentLocale = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getLocale();
      Iterator<LocaleConfig> i = localeService.getLocalConfigs().iterator();
      String displayLanguage = null;
      String displayName = null;
      String language = null;
      String country = null;
      SelectItemOption<String> option;
      while (i.hasNext())
      {
         LocaleConfig config = i.next();
         Locale locale = config.getLocale();
         displayName = locale.getDisplayName(currentLocale);
         language = locale.getLanguage();
         country = locale.getCountry();
         if (country != null && country.length() > 0)
         {
            displayLanguage = displayName + " (" + locale.getDisplayCountry(currentLocale) + ")";
            language = language + "_" + country;
         }
         else
         {
            displayLanguage = displayName;
         }
         option = new SelectItemOption<String>(displayLanguage, language, displayName);
         if (language.equals(selectedLang))
         {
            option.setSelected(true);
         }
         if (config.getLanguage().equals("en"))
         {
            lang.add(0, option);
            continue;
         }
         lang.add(option);
      }

      langSelectBox.setOptions(lang);
   }

   @SuppressWarnings("deprecation")
   public void setUserProfile(String user) throws Exception
   {
      user_ = user;
      if (user == null)
         return;
      OrganizationService service = getApplicationComponent(OrganizationService.class);
      UserProfile userProfile = service.getUserProfileHandler().findUserProfileByName(user);
      if (userProfile == null)
      {
         userProfile = service.getUserProfileHandler().createUserProfileInstance();
         userProfile.setUserName(user);
      }

      if (userProfile.getUserInfoMap() == null)
         return;
      for (UIComponent set : getChildren())
      {
         UIFormInputSet inputSet = (UIFormInputSet)set;
         for (UIComponent uiComp : inputSet.getChildren())
         {
            UIFormStringInput uiInput = (UIFormStringInput)uiComp;
            uiInput.setValue(userProfile.getAttribute(uiInput.getName()));
         }
      }
   }

   @SuppressWarnings("deprecation")
   public void save(OrganizationService service, String user, boolean isnewUser) throws Exception
   {
      user_ = user;
      UserProfileHandler hanlder = service.getUserProfileHandler();
      UserProfile userProfile = hanlder.findUserProfileByName(user_);

      if (userProfile == null)
      {
         userProfile = hanlder.createUserProfileInstance();
         userProfile.setUserName(user_);
      }

      for (UIComponent set : getChildren())
      {
         UIFormInputSet inputSet = (UIFormInputSet)set;
         for (UIComponent uiComp : inputSet.getChildren())
         {
            UIFormStringInput uiInput = (UIFormStringInput)uiComp;
            // if(uiInput.getValue() == null || uiInput.getValue().length() < 1)
            // continue;
            userProfile.getUserInfoMap().put(uiInput.getName(), uiInput.getValue());
         }
      }

      hanlder.saveUserProfile(userProfile, true);

      Object[] args = {"UserProfile", user_};
      WebuiRequestContext context = WebuiRequestContext.getCurrentInstance();
      UIApplication uiApp = context.getUIApplication();
      if (isnewUser)
      {
         uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.successful.create.user", args));
         return;
      }
      uiApp.addMessage(new ApplicationMessage("UIUserProfileInputSet.msg.sucsesful.update.userprofile", args));
   }

}
