/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="system:/groovy/webui/form/UIVTabInputSet.gtmpl")
@Serialized
public class UIUserProfileInputSet
extends UIFormInputSet {
    private String user_;
    public static final String MALE = "male";
    public static final String FEMALE = "female";

    public UIUserProfileInputSet() {
    }

    public UIUserProfileInputSet(String name) throws Exception {
        super(name);
        this.setComponentConfig(UIUserProfileInputSet.class, null);
        UIFormInputSet personalInputSet = new UIFormInputSet("Profile");
        this.addInput(personalInputSet, UserProfile.PERSONAL_INFO_KEYS);
        this.addUIFormInput(personalInputSet);
        UIFormInputSet homeInputSet = new UIFormInputSet("HomeInfo");
        this.addInput(homeInputSet, UserProfile.HOME_INFO_KEYS);
        homeInputSet.setRendered(false);
        this.addUIFormInput(homeInputSet);
        UIFormInputSet businessInputSet = new UIFormInputSet("BusinessInfo");
        this.addInput(businessInputSet, UserProfile.BUSINESE_INFO_KEYS);
        businessInputSet.setRendered(false);
        this.addUIFormInput(businessInputSet);
    }

    public void reset() {
        for (UIComponent uiChild : this.getChildren()) {
            if (!(uiChild instanceof UIFormInputSet) && !(uiChild instanceof UIFormInput)) continue;
            ((UIFormInputSet)uiChild).reset();
        }
    }

    private void addInput(UIFormInputSet set, String[] keys) {
        for (String key : keys) {
            if (key.equalsIgnoreCase("user.gender")) {
                ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
                ls.add(new SelectItemOption(MALE, (Object)MALE));
                ls.add(new SelectItemOption(FEMALE, (Object)FEMALE));
                UIFormSelectBox genderSelectBox = new UIFormSelectBox(key, key, ls);
                set.addUIFormInput((UIFormInput)genderSelectBox);
                continue;
            }
            if (key.equalsIgnoreCase("user.language")) {
                UIFormSelectBox langSelectBox = new UIFormSelectBox(key, key, null);
                set.addUIFormInput((UIFormInput)langSelectBox);
                this.initLanguageCombo(langSelectBox);
                continue;
            }
            set.addUIFormInput((UIFormInput)new UIFormStringInput(key, null, null));
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIFormSelectBox langSelectBox = (UIFormSelectBox)this.findComponentById("user.language");
        this.initLanguageCombo(langSelectBox);
        super.processRender(context);
    }

    private void initLanguageCombo(UIFormSelectBox langSelectBox) {
        if (langSelectBox == null) {
            return;
        }
        String selectedLang = langSelectBox.getSelectedValues()[0];
        ArrayList<SelectItemOption> lang = new ArrayList<SelectItemOption>();
        langSelectBox.setOptions(lang);
        LocaleConfigService localeService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        Locale currentLocale = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getLocale();
        Iterator i = localeService.getLocalConfigs().iterator();
        String displayName = null;
        String language = null;
        String country = null;
        while (i.hasNext()) {
            LocaleConfig config = (LocaleConfig)i.next();
            Locale locale = config.getLocale();
            language = locale.getLanguage();
            country = locale.getCountry();
            if (country != null && country.length() > 0) {
                language = language + "_" + country;
            }
            displayName = null;
            try {
                String translation;
                ResourceBundle localeResourceBundle = this.getResourceBundle(currentLocale);
                String key = "Locale." + language;
                displayName = translation = localeResourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                displayName = this.capitalizeFirstLetter(locale.getDisplayName(currentLocale));
            }
            catch (Exception e) {
                // empty catch block
            }
            SelectItemOption option = new SelectItemOption(displayName, (Object)language);
            if (language.equals(selectedLang)) {
                option.setSelected(true);
            }
            lang.add(option);
        }
        lang.add(new SelectItemOption("", (Object)""));
        Collections.sort(lang, new LanguagesComparator());
        langSelectBox.setOptions(lang);
    }

    public void setUserProfile(String user) throws Exception {
        this.user_ = user;
        if (user == null) {
            return;
        }
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        UserProfile userProfile = service.getUserProfileHandler().findUserProfileByName(user);
        if (userProfile == null) {
            userProfile = service.getUserProfileHandler().createUserProfileInstance();
            userProfile.setUserName(user);
        }
        if (userProfile.getUserInfoMap() == null) {
            return;
        }
        for (UIComponent set : this.getChildren()) {
            UIFormInputSet inputSet = (UIFormInputSet)set;
            for (UIComponent uiComp : inputSet.getChildren()) {
                UIFormStringInput uiInput = (UIFormStringInput)uiComp;
                uiInput.setValue((Object)userProfile.getAttribute(uiInput.getName()));
            }
        }
    }

    public void save(OrganizationService service, String user, boolean isnewUser) throws Exception {
        this.user_ = user;
        UserProfileHandler hanlder = service.getUserProfileHandler();
        UserProfile userProfile = hanlder.findUserProfileByName(this.user_);
        if (userProfile == null) {
            userProfile = hanlder.createUserProfileInstance();
            userProfile.setUserName(this.user_);
        }
        for (UIComponent set : this.getChildren()) {
            UIFormInputSet inputSet = (UIFormInputSet)set;
            for (UIComponent uiComp : inputSet.getChildren()) {
                UIFormStringInput uiInput = (UIFormStringInput)uiComp;
                userProfile.getUserInfoMap().put(uiInput.getName(), uiInput.getValue());
            }
        }
        hanlder.saveUserProfile(userProfile, true);
        Object[] args = new Object[]{"UserProfile", this.user_};
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIApplication uiApp = context.getUIApplication();
        if (isnewUser) {
            uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.successful.create.user", args));
            return;
        }
        uiApp.addMessage(new ApplicationMessage("UIUserProfileInputSet.msg.sucsesful.update.userprofile", args));
    }

    private String capitalizeFirstLetter(String word) {
        if (word == null) {
            return null;
        }
        if (word.length() == 0) {
            return word;
        }
        StringBuilder result = new StringBuilder(word);
        result.replace(0, 1, result.substring(0, 1).toUpperCase());
        return result.toString();
    }

    private ResourceBundle getResourceBundle(Locale locale) throws Exception {
        ExoContainer appContainer = ExoContainerContext.getCurrentContainer();
        ResourceBundleService service = (ResourceBundleService)appContainer.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle("locale.portal.webui", locale);
        return res;
    }

    private class LanguagesComparator
    implements Comparator<SelectItemOption> {
        private LanguagesComparator() {
        }

        @Override
        public int compare(SelectItemOption item0, SelectItemOption item1) {
            return item0.getLabel().compareToIgnoreCase(item1.getLabel());
        }
    }
}

