/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.samples.lazytabpane;

import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PasswordStringLengthValidator;
import org.exoplatform.webui.form.validator.ResourceValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

/**
 * Created by The eXo Platform SARL
 * Author : tam.nguyen
 *          tamndrok@gmail.com
 * July 21, 2009
 */
@ComponentConfig(
                 lifecycle = UIFormLifecycle.class,
                 template = "app:/groovy/webui/component/UILazyTabPaneInputSet.gtmpl"
)
public class UILazyTabPaneInputSet2 extends UIForm {
  
  
  public UILazyTabPaneInputSet2() throws Exception {
    addUIFormInput(new UIFormStringInput("newUserName", "userName", null).
                   addValidator(MandatoryValidator.class).
                   addValidator(StringLengthValidator.class, 3, 30).
                   addValidator(ResourceValidator.class).
                   addValidator(ExpressionValidator.class, "^[\\p{L}][\\p{L}._\\-\\d]+$", "ResourceValidator.msg.Invalid-char"));
    addUIFormInput(new UIFormStringInput("newPassword", "password", null).
                   setType(UIFormStringInput.PASSWORD_TYPE).
                   addValidator(MandatoryValidator.class).
                   addValidator(PasswordStringLengthValidator.class, 6, 30)) ;
    addUIFormInput(new UIFormStringInput("newConfirmPassword", "password", null).
                   setType(UIFormStringInput.PASSWORD_TYPE).
                   addValidator(MandatoryValidator.class).
                   addValidator(PasswordStringLengthValidator.class, 6, 30));
  }
  
}
