/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.Environment;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletContainerConf;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.PortletContainerPlugin;
import org.exoplatform.services.portletcontainer.PortletProcessingException;
import org.exoplatform.services.portletcontainer.helper.IOUtil;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.helper.WindowInfosContainer;
import org.exoplatform.services.portletcontainer.pci.ActionInput;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.EventInput;
import org.exoplatform.services.portletcontainer.pci.EventOutput;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.Output;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.ResourceInput;
import org.exoplatform.services.portletcontainer.pci.ResourceOutput;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.CustomPortletMode;
import org.exoplatform.services.portletcontainer.pci.model.EventDefinition;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.pci.model.Util;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationHandler;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationsHolder;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletPreferencesImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.persistenceImp.PersistenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContainerDispatcher
implements PortletContainerPlugin {
    public static final String INPUT = "org.exoplatform.services.portletcontainer.pci.Input";
    public static final String OUTPUT = "org.exoplatform.services.portletcontainer.pci.Output";
    public static final String WINDOW_INFO = "org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.PortletWindowInternal";
    public static final String IS_ACTION = "org.exoplatform.services.portletcontainer.plugins.pc.isAction";
    public static final String IS_TO_GET_BUNDLE = "org.exoplatform.services.portletcontainer.plugins.pc.isToGetBundle";
    public static final String LOCALE_FOR_BUNDLE = "org.exoplatform.services.portletcontainer.plugins.pc.LocaleForBundle";
    public static final String BUNDLE = "org.exoplatform.services.portletcontainer.plugins.pc.Bundle";
    public static final String PORTLET_APPLICATION_NAME = "org.exoplatform.services.portletcontainer.plugins.pc.PortletAppName";
    public static final String PORTLET_NAME = "org.exoplatform.services.portletcontainer.plugins.pc.PortletName";
    public static final String CONTAINER = "org.exoplatform.container.ExoContainer";
    public static final String EXCEPTION = "org.exoplatform.services.portletcontainer.PortletProcessingException";
    public static final String SERVLET_MAPPING = "/PortletWrapper";
    public static final String ATTRS = "org.exoplatform.services.portletcontainer.pci.ATTRS";
    private final PortletContainerConf config;
    private final PersistenceManager manager;
    private final PortletApplicationsHolder portletApplications;
    private final PortletApplicationHandler standAloneHandler;
    private static final Log LOG = ExoLogger.getLogger(PortletContainerDispatcher.class);
    protected ExoContainer container;
    private String pluginName;

    public PortletContainerDispatcher(PortletContainerConf containerConf, PersistenceManager manager, PortletApplicationsHolder holder, PortletApplicationHandler standAloneHandler, ExoContainerContext context) {
        this.portletApplications = holder;
        this.config = containerConf;
        this.manager = manager;
        this.standAloneHandler = standAloneHandler;
        this.container = context.getContainer();
    }

    public final void setName(String name) {
        this.pluginName = name;
    }

    public final String getName() {
        return this.pluginName;
    }

    public final void setDescription(String description) {
        this.config.setDescription(description);
    }

    public final String getDescription() {
        return this.config.getDescription();
    }

    public final void setMajorVersion(int majorVersion) {
        this.config.setMajorVersion(majorVersion);
    }

    public final void setMinorVersion(int minorVersion) {
        this.config.setMinorVersion(minorVersion);
    }

    public final void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    public final Collection<PortletMode> getSupportedPortletModes() {
        return Collections.unmodifiableCollection(Collections.list(this.config.getSupportedPortletModes()));
    }

    public final Collection<WindowState> getSupportedWindowStates() {
        return Collections.unmodifiableCollection(Collections.list(this.config.getSupportedWindowStates()));
    }

    public final Collection<PortletMode> getPortletModes(String portletAppName, String portletName, String markup) {
        ArrayList<PortletMode> filteredModes = new ArrayList<PortletMode>();
        Collection<PortletMode> nonFilteredModes = this.portletApplications.getPortletModes(portletAppName, portletName, markup);
        for (PortletMode mode : nonFilteredModes) {
            Enumeration portalModes = this.config.getSupportedPortletModes();
            while (portalModes.hasMoreElements()) {
                PortletMode portalMode = (PortletMode)portalModes.nextElement();
                if (!mode.equals((Object)portalMode)) continue;
                filteredModes.add(mode);
            }
        }
        return filteredModes;
    }

    public final String[] getPortalManagedPortletModes(String portletAppName, String portletName) {
        PortletApp portletApp = this.getPortletApp(portletAppName);
        List supports = portletApp.getPortlet(portletName).getSupports();
        List customPortletModes = portletApp.getCustomPortletMode();
        ArrayList<String> resultManagedModes = new ArrayList<String>();
        for (Supports support : supports) {
            List portletModes = support.getPortletMode();
            for (String mode : portletModes) {
                for (CustomPortletMode customPortletMode : customPortletModes) {
                    if (!mode.equalsIgnoreCase(customPortletMode.getPortletMode()) || !customPortletMode.isPortalManaged().booleanValue()) continue;
                    resultManagedModes.add(customPortletMode.getPortletMode());
                }
            }
        }
        return resultManagedModes.toArray(new String[resultManagedModes.size()]);
    }

    public final boolean isModeSuported(String portletAppName, String portletName, String markup, PortletMode mode) {
        boolean isPortalMode = false;
        Enumeration portalModes = this.config.getSupportedPortletModes();
        while (portalModes.hasMoreElements()) {
            PortletMode portalMode = (PortletMode)portalModes.nextElement();
            if (!portalMode.equals((Object)mode)) continue;
            isPortalMode = true;
            break;
        }
        return this.portletApplications.isModeSuported(portletAppName, portletName, markup, mode) && isPortalMode;
    }

    public final Collection<WindowState> getWindowStates(String portletAppName, String portletName, String markup) {
        ArrayList<WindowState> filteredStates = new ArrayList<WindowState>();
        Collection<WindowState> nonFilteredStates = this.portletApplications.getWindowStates(portletAppName, portletName, markup);
        for (WindowState state : nonFilteredStates) {
            Enumeration portalStates = this.config.getSupportedWindowStates();
            while (portalStates.hasMoreElements()) {
                WindowState portalState = (WindowState)portalStates.nextElement();
                if (!state.equals((Object)portalState)) continue;
                filteredStates.add(state);
            }
        }
        return filteredStates;
    }

    public final boolean isStateSupported(String portletAppName, String portletName, String markup, WindowState state) {
        boolean isPortalState = false;
        Enumeration portalStates = this.config.getSupportedWindowStates();
        while (portalStates.hasMoreElements()) {
            WindowState portalState = (WindowState)portalStates.nextElement();
            if (!portalState.equals((Object)state)) continue;
            isPortalState = true;
            break;
        }
        return this.portletApplications.isStateSupported(portletAppName, portletName, markup, state) && isPortalState;
    }

    public final Map<String, PortletData> getAllPortletMetaData() {
        return this.portletApplications.getAllPortletMetaData();
    }

    public final Collection<String> getPortletAppNames() {
        return this.portletApplications.getPortletAppNames();
    }

    public final PortletApp getPortletApp(String portletAppName) {
        return this.portletApplications.getPortletApplication(portletAppName);
    }

    public final boolean isEventPayloadTypeMatches(String portletAppName, QName eventName, Serializable payload) {
        PortletApp portletApp = this.portletApplications.getPortletApplication(portletAppName);
        List eds = portletApp.getEventDefinition();
        return PortletContainerDispatcher.isEventPayloadTypeMatches(eds, payload, eventName);
    }

    public static boolean isEventPayloadTypeMatches(List<EventDefinition> eds, Serializable payload, QName eventName) {
        if (eds == null || payload == null) {
            return true;
        }
        for (EventDefinition ed : eds) {
            if (!ed.getPrefferedName().equals(eventName) || ed.getAliases() == null || !ed.getAliases().contains(eventName)) continue;
            if (ed.getJavaClass() == null) {
                return true;
            }
            Class<?> jc = null;
            try {
                jc = payload.getClass().getClassLoader().loadClass(ed.getJavaClass());
            }
            catch (Exception e1) {
                try {
                    jc = Class.forName(ed.getJavaClass(), true, payload.getClass().getClassLoader());
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Event loaded class for eventName: '" + eventName + "' is: " + jc));
            }
            if (jc != null) {
                return jc.isInstance(payload);
            }
            return false;
        }
        return true;
    }

    public final void setPortletPreference(Input input, Map<String, String> preferencesMap) throws PortletContainerException {
        LOG.debug((Object)"try to set a portlet preference directly from the setPortletPreference() method");
        WindowID windowID = input.getInternalWindowID();
        Portlet pDatas = this.portletApplications.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
        ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
        PortletWindowInternal windowInfos = this.manager.getWindow(input, defaultPrefs);
        PortletPreferencesImp preferences = (PortletPreferencesImp)windowInfos.getPreferences();
        preferences.setMethodCalledIsAction(1);
        Set<String> keys = preferencesMap.keySet();
        try {
            for (String key : keys) {
                try {
                    preferences.setValue(key, preferencesMap.get(key));
                }
                catch (ReadOnlyException e) {
                    LOG.error((Object)"Can not set a property that has a ReadOnly tag set to true", (Throwable)e);
                }
            }
            preferences.store();
        }
        catch (Exception e) {
            LOG.error((Object)"Can not store a portlet preference", (Throwable)e);
            throw new PortletContainerException((Throwable)e);
        }
    }

    public final Map<String, String[]> getPortletPreference(Input input) {
        return this.getPortletPreferences(input).getMap();
    }

    public PortletPreferences getPortletPreferences(Input input) {
        LOG.debug((Object)"Try to get a portlet preference directly from the getPortletPreference() method ");
        WindowID windowID = input.getInternalWindowID();
        Portlet pDatas = this.portletApplications.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
        ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
        PortletWindowInternal windowInfos = this.manager.getWindow(input, defaultPrefs);
        PortletPreferencesImp preferences = (PortletPreferencesImp)windowInfos.getPreferences();
        return preferences;
    }

    public void setPortletPreference2(Input input, Map<String, String[]> preferencesMap) throws PortletContainerException {
        LOG.debug((Object)"try to set a portlet preference directly from the setPortletPreference2() method");
        WindowID windowID = input.getInternalWindowID();
        Portlet pDatas = this.portletApplications.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
        ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
        PortletWindowInternal windowInfos = this.manager.getWindow(input, defaultPrefs);
        PortletPreferencesImp preferences = (PortletPreferencesImp)windowInfos.getPreferences();
        preferences.setMethodCalledIsAction(1);
        Set<String> keys = preferencesMap.keySet();
        try {
            for (String key : keys) {
                try {
                    preferences.setValues(key, preferencesMap.get(key));
                }
                catch (ReadOnlyException e) {
                    LOG.error((Object)"Can not set a property that has a ReadOnly tag set to true", (Throwable)e);
                }
            }
            preferences.store();
        }
        catch (Exception e) {
            LOG.error((Object)"Can not store a portlet preference", (Throwable)e);
            throw new PortletContainerException((Throwable)e);
        }
    }

    public void setPortletPreferences(Input input, PortletPreferences preferences) throws PortletContainerException {
        LOG.debug((Object)"try to set a portlet preference directly from the setPortletPreferences() method");
        WindowID windowID = input.getInternalWindowID();
        Portlet pDatas = this.portletApplications.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
        ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
        PortletWindowInternal windowInfos = this.manager.getWindow(input, defaultPrefs);
        windowInfos.setPreferences(preferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResourceBundle getBundle(HttpServletRequest request, HttpServletResponse response, String portletAppName, String portletName, Locale locale) throws PortletContainerException {
        LOG.debug((Object)("Try to get a bundle object for locale : " + locale));
        int platform = Environment.getInstance().getPlatform();
        if (platform == 1) {
            URLClassLoader oldCL = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            this.initTests();
            try {
                ResourceBundle resourceBundle = this.standAloneHandler.getBundle(portletAppName, portletName, locale);
                Object var10_10 = null;
                Thread.currentThread().setContextClassLoader(oldCL);
                return resourceBundle;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                Thread.currentThread().setContextClassLoader(oldCL);
                throw throwable;
            }
        }
        request.setAttribute(CONTAINER, (Object)this.container.getContext().getName());
        request.setAttribute(IS_TO_GET_BUNDLE, (Object)new Boolean(true));
        request.setAttribute(LOCALE_FOR_BUNDLE, (Object)locale);
        request.setAttribute(PORTLET_APPLICATION_NAME, (Object)portletAppName);
        request.setAttribute(PORTLET_NAME, (Object)portletName);
        this.dispatch(request, response, portletAppName);
        ResourceBundle bundle = (ResourceBundle)request.getAttribute(BUNDLE);
        request.removeAttribute(CONTAINER);
        request.removeAttribute(IS_TO_GET_BUNDLE);
        request.removeAttribute(LOCALE_FOR_BUNDLE);
        request.removeAttribute(PORTLET_APPLICATION_NAME);
        request.removeAttribute(PORTLET_NAME);
        request.removeAttribute(BUNDLE);
        return bundle;
    }

    public final ActionOutput processAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionInput actionInput) throws PortletContainerException {
        LOG.debug((Object)"ProcessAction method in PortletContainerDispatcher entered");
        return (ActionOutput)this.process(httpServletRequest, httpServletResponse, (Input)actionInput, 1);
    }

    public final EventOutput processEvent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, EventInput eventInput) throws PortletContainerException {
        LOG.debug((Object)"ProcessEvent method in PortletContainerDispatcher entered");
        return (EventOutput)this.process(httpServletRequest, httpServletResponse, (Input)eventInput, 2);
    }

    public final RenderOutput render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RenderInput renderInput) throws PortletContainerException {
        LOG.debug((Object)"Render method in PortletContainerDispatcher entered");
        return (RenderOutput)this.process(httpServletRequest, httpServletResponse, (Input)renderInput, 0);
    }

    public final ResourceOutput serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceInput resourceInput) throws PortletContainerException {
        LOG.debug((Object)"ServeResource method in PortletContainerDispatcher entered");
        return (ResourceOutput)this.process(httpServletRequest, httpServletResponse, (Input)resourceInput, 3);
    }

    public final void sendAttrs(HttpServletRequest request, HttpServletResponse response, Map<String, Object> attrs, String portletApplicationName) throws PortletContainerException {
        request.setAttribute(CONTAINER, (Object)this.container.getContext().getName());
        try {
            Set<Map.Entry<String, Object>> s = attrs.entrySet();
            Iterator<Map.Entry<String, Object>> it = s.iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                if (entry.getValue() != null) continue;
                it.remove();
                request.removeAttribute(entry.getKey());
            }
            request.setAttribute(ATTRS, attrs);
            int platform = Environment.getInstance().getPlatform();
            if (platform != 1) {
                this.dispatch(request, response, portletApplicationName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Output process(HttpServletRequest request, HttpServletResponse response, Input input, int isAction) throws PortletContainerException {
        LOG.debug((Object)"Process method in PortletContainerDispatcher entered");
        LOG.debug((Object)("Encoding used : " + request.getCharacterEncoding()));
        Object output = null;
        output = isAction == 1 ? new ActionOutput() : (isAction == 2 ? new EventOutput() : (isAction == 3 ? new ResourceOutput() : new RenderOutput()));
        PortletWindowInternal windowInfos = this.getWindowInfos(request, input, isAction);
        String portletApplicationName = windowInfos.getWindowID().getPortletApplicationName();
        ExceptionHolder exceptionHolder = new ExceptionHolder();
        request.setAttribute(CONTAINER, (Object)this.container.getContext().getName());
        request.setAttribute(INPUT, (Object)input);
        request.setAttribute(OUTPUT, output);
        request.setAttribute(WINDOW_INFO, (Object)windowInfos);
        request.setAttribute(IS_ACTION, (Object)Util.actionToString((int)isAction));
        request.setAttribute(EXCEPTION, (Object)exceptionHolder);
        int platform = Environment.getInstance().getPlatform();
        if (platform == 1) {
            LOG.debug((Object)"Stand alone environement : direct call to handler");
            URLClassLoader oldCL = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            this.initTests();
            try {
                ServletContext portalContext = (ServletContext)this.container.getComponentInstanceOfType(ServletContext.class);
                this.standAloneHandler.process(portalContext, request, response, input, (Output)output, windowInfos, isAction);
                Object var13_13 = null;
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                Thread.currentThread().setContextClassLoader(oldCL);
                throw throwable;
            }
        }
        LOG.debug((Object)"Embded environement : use servlet dispatcher to access handler");
        try {
            this.dispatch(request, response, portletApplicationName);
            Object var15_16 = null;
            ((PortletPreferencesImp)windowInfos.getPreferences()).discard();
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            ((PortletPreferencesImp)windowInfos.getPreferences()).discard();
            throw throwable;
        }
        if (input.isStateSaveOnClient() && isAction == 1) {
            try {
                LOG.debug((Object)"Serialize Portlet Preferences object to store it on the client");
                output.setPortletState(IOUtil.serialize((Object[])new Object[]{windowInfos.getPreferences()}));
            }
            catch (Exception e) {
                LOG.error((Object)"Can not serialize Portlet Preferences", (Throwable)e);
                throw new PortletContainerException("Can not serialize Portlet Preferences", (Throwable)e);
            }
        }
        if (exceptionHolder.getException() != null) {
            throw exceptionHolder.getException();
        }
        return output;
    }

    private PortletWindowInternal getWindowInfos(HttpServletRequest request, Input input, int isAction) {
        boolean stateChangeAuthorized = true;
        if (isAction == 1) {
            stateChangeAuthorized = ((ActionInput)input).isStateChangeAuthorized();
        }
        PortletWindowInternal windowInfos = null;
        if (!input.isStateSaveOnClient()) {
            LOG.debug((Object)"Extract or create windows info (store in the server)");
            WindowInfosContainer windowInfosContainer = WindowInfosContainer.getInstance();
            String key = "SESSION_CONTAINER_KEY_ENCODER" + input.getInternalWindowID().generateKey();
            if (windowInfosContainer.getInfos(key) != null) {
                windowInfos = windowInfosContainer.getInfos(key);
            } else {
                WindowID windowID = input.getInternalWindowID();
                Portlet pDatas = this.portletApplications.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
                ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
                windowInfos = this.manager.getWindow(input, defaultPrefs);
                windowInfosContainer.addInfos(key, windowInfos);
            }
        } else {
            LOG.debug((Object)"Extract or create windows info (sent by the client)");
            WindowID windowID = input.getInternalWindowID();
            Portlet pDatas = this.portletApplications.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
            ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
            windowInfos = this.manager.getWindow(input, defaultPrefs);
        }
        ((PortletPreferencesImp)windowInfos.getPreferences()).setMethodCalledIsAction(isAction);
        ((PortletPreferencesImp)windowInfos.getPreferences()).setStateChangeAuthorized(stateChangeAuthorized);
        ((PortletPreferencesImp)windowInfos.getPreferences()).setStateSaveOnClient(input.isStateSaveOnClient());
        return windowInfos;
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response, String portletApplicationName) throws PortletContainerException {
        ServletContext portalContext = (ServletContext)this.container.getComponentInstanceOfType(ServletContext.class);
        ServletContext portletContext = portalContext.getContext("/" + portletApplicationName);
        if (portletContext == null) {
            LOG.error((Object)("Can't get servlet context for portlet app [" + portletApplicationName + "]. May be it's caused " + "by difference between context name (usually WAR file name) and content of tag <display-name/> in your " + "WEB-INF/web.xml"));
        }
        RequestDispatcher dispatcher = portletContext.getRequestDispatcher(SERVLET_MAPPING);
        try {
            LOG.debug((Object)("Dispatch request to the portlet application : " + portletApplicationName));
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            LOG.error((Object)"Servlet exception while dispatching to portlet", (Throwable)e);
            throw new PortletContainerException((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"In and out exception while dispatching to portlet", (Throwable)e);
            throw new PortletContainerException((Throwable)e);
        }
    }

    private void initTests() {
        String PORTLET_APP_PATH = "file:./war_template/";
        String PORTLET_APP_PATH2 = "file:" + System.getProperty("testPath") + "/war_template";
        try {
            URL[] URLs = new URL[]{new URL("file:./war_template/WEB-INF/classes/"), new URL("file:./lib/portlet-api.jar"), new URL("file:./war_template/WEB-INF/lib/")};
            Thread.currentThread().setContextClassLoader(new URLClassLoader(URLs, Thread.currentThread().getContextClassLoader()));
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Can not init tests", (Throwable)e);
        }
    }

    private void initTests2() {
    }

    public class ExceptionHolder {
        private PortletProcessingException exception;

        public PortletProcessingException getException() {
            return this.exception;
        }

        public void setException(PortletProcessingException exception) {
            this.exception = exception;
        }
    }
}

