/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.aop;

import java.lang.reflect.Method;
import java.util.Collections;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.component.ExecutionContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.BaseCommandUnit;

public class PortletSessionIdentityScopingCommand
extends BaseCommandUnit {
    private static final Log log = ExoLogger.getLogger(PortletSessionIdentityScopingCommand.class);
    private static final String IDENTITY_TOKEN = "javax.portlet.identity.token";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ExecutionContext context) throws Throwable {
        Object o;
        PortletRequest request;
        try {
            Method getRequest = context.getClass().getDeclaredMethod("getRequest", new Class[0]);
            getRequest.setAccessible(true);
            request = (PortletRequest)getRequest.invoke((Object)context, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error invoking method getRequest() from class " + context.getClass() + " -- " + e.toString());
        }
        String portalIdentity = request.getRemoteUser();
        this.check(request, portalIdentity);
        try {
            o = super.execute(context);
        }
        finally {
            this.update(request, portalIdentity);
        }
        return o;
    }

    private void update(PortletRequest request, String portalIdentity) {
        boolean trace = log.isTraceEnabled();
        String contextPath = request.getContextPath();
        PortletSession session = request.getPortletSession(false);
        if (session != null) {
            String id = session.getId();
            String sessionIdentity = (String)session.getAttribute(IDENTITY_TOKEN, 1);
            if (portalIdentity != null) {
                if (!portalIdentity.equals(sessionIdentity)) {
                    if (trace) {
                        log.trace((Object)("Updating portlet session " + id + " (" + contextPath + ") from " + sessionIdentity + " to " + portalIdentity));
                    }
                    session.setAttribute(IDENTITY_TOKEN, (Object)portalIdentity, 1);
                }
            } else if (sessionIdentity != null) {
                if (trace) {
                    log.trace((Object)("Updating portlet session " + id + " (" + contextPath + ") by removing the " + sessionIdentity + " value"));
                }
                session.removeAttribute(IDENTITY_TOKEN, 1);
            }
        }
    }

    private void check(PortletRequest request, String portalIdentity) {
        boolean trace = log.isTraceEnabled();
        String contextPath = request.getContextPath();
        PortletSession session = request.getPortletSession(false);
        if (session != null) {
            String id = session.getId();
            String sessionIdentity = (String)session.getAttribute(IDENTITY_TOKEN, 1);
            if (portalIdentity == null) {
                if (sessionIdentity != null) {
                    if (trace) {
                        log.trace((Object)("Detected user logout for session " + id + " (" + contextPath + ")"));
                    }
                    this.purge(session);
                }
            } else if (sessionIdentity != null && !sessionIdentity.equals(portalIdentity)) {
                if (trace) {
                    log.trace((Object)("Detected different user for session " + id + " (" + contextPath + ")"));
                }
                this.purge(session);
            }
        }
    }

    private void purge(PortletSession session) {
        for (String name : Collections.list(session.getAttributeNames(1))) {
            session.removeAttribute(name, 1);
        }
    }
}

