/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.aop;

import org.exoplatform.container.component.ExecutionContext;
import org.exoplatform.container.component.ExecutionUnit;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.ActionExecutionContext;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.EventExecutionContext;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.RenderExecutionContext;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.ResourceExecutionContext;

public abstract class BaseCommandUnit
extends ExecutionUnit {
    protected Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");

    public Object execute(ExecutionContext context) throws Throwable {
        if (context instanceof RenderExecutionContext) {
            RenderExecutionContext rcontext = (RenderExecutionContext)context;
            return this.render(rcontext);
        }
        if (context instanceof EventExecutionContext) {
            EventExecutionContext econtext = (EventExecutionContext)context;
            return this.processEvent(econtext);
        }
        if (context instanceof ResourceExecutionContext) {
            ResourceExecutionContext rcontext = (ResourceExecutionContext)context;
            return this.serveResource(rcontext);
        }
        ActionExecutionContext acontext = (ActionExecutionContext)context;
        return this.processAction(acontext);
    }

    protected Object render(RenderExecutionContext rcontext) throws Throwable {
        return rcontext.executeNextUnit();
    }

    protected Object serveResource(ResourceExecutionContext rcontext) throws Throwable {
        return rcontext.executeNextUnit();
    }

    protected Object processEvent(EventExecutionContext econtext) throws Throwable {
        return econtext.executeNextUnit();
    }

    protected Object processAction(ActionExecutionContext acontext) throws Throwable {
        return acontext.executeNextUnit();
    }
}

