/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.EventRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.CustomRequestWrapper;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.CustomResponseWrapper;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.NestedResponseWrapper;

public class PortletRequestDispatcherImp
implements PortletRequestDispatcher {
    private final String path;
    private final RequestDispatcher dispatcher;
    private final Log log;
    private ExoContainer cont;

    public PortletRequestDispatcherImp(ExoContainer cont, RequestDispatcher dispatcher, String path) {
        this.dispatcher = dispatcher;
        this.path = path;
        this.cont = cont;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
    }

    public void include(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.include((PortletRequest)renderRequest, (PortletResponse)renderResponse);
    }

    public void include(PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException, IOException {
        CustomRequestWrapper requestWrapper = null;
        try {
            byte[] ca;
            requestWrapper = (CustomRequestWrapper)((HttpServletRequestWrapper)portletRequest).getRequest();
            CustomResponseWrapper realResponseWrapper = (CustomResponseWrapper)((HttpServletResponseWrapper)portletResponse).getResponse();
            NestedResponseWrapper responseWrapper = new NestedResponseWrapper((HttpServletResponse)realResponseWrapper);
            portletRequest.setAttribute("javax.portlet.config", (Object)((PortletRequestImp)portletRequest).getPortletConfig());
            portletRequest.setAttribute("javax.portlet.request", (Object)portletRequest);
            portletRequest.setAttribute("javax.portlet.response", (Object)portletResponse);
            if (portletRequest instanceof ActionRequest) {
                portletRequest.setAttribute("javax.portlet.lifecycle_phase", (Object)"ACTION_PHASE");
                responseWrapper.setCommitted();
                responseWrapper.setNoValues(true);
            } else if (portletRequest instanceof EventRequest) {
                portletRequest.setAttribute("javax.portlet.lifecycle_phase", (Object)"EVENT_PHASE");
                requestWrapper.setNoInput(true);
                requestWrapper.setNoValues(true);
                responseWrapper.setCommitted();
                responseWrapper.setNoValues(true);
            } else if (portletRequest instanceof ResourceRequest) {
                portletRequest.setAttribute("javax.portlet.lifecycle_phase", (Object)"RESOURCE_PHASE");
                responseWrapper.setContentType(((ResourceResponse)portletResponse).getContentType());
            } else {
                requestWrapper.setNoInput(true);
                requestWrapper.setNoValues(true);
                portletRequest.setAttribute("javax.portlet.lifecycle_phase", (Object)"RENDER_PHASE");
                responseWrapper.setContentType(((RenderResponse)portletResponse).getContentType());
            }
            responseWrapper.flushBuffer();
            requestWrapper.setRedirected(true);
            requestWrapper.setRedirectedPath(this.path);
            requestWrapper.setContextPath(portletRequest.getContextPath());
            if (this.dispatcher != null) {
                this.dispatcher.include((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            }
            if ((ca = responseWrapper.getPortletContent()) == null) {
                ca = new byte[]{};
            }
            if (realResponseWrapper.isStreamUsed()) {
                realResponseWrapper.getOutputStream().write(ca);
            } else {
                realResponseWrapper.getWriter().write(new String(ca, "utf-8"));
            }
        }
        catch (ServletException e) {
            if (e.getRootCause() != null) {
                this.log.error((Object)"Root cause of the exception", e.getRootCause());
            }
            this.log.error((Object)"Problems occur when using PortletDispatcher", (Throwable)e);
            throw new PortletException("Problems occur when using PortletDispatcher", (Throwable)e);
        }
        finally {
            portletRequest.removeAttribute("javax.portlet.config");
            portletRequest.removeAttribute("javax.portlet.request");
            portletRequest.removeAttribute("javax.portlet.response");
            portletRequest.removeAttribute("javax.portlet.lifecycle_phase");
            if (requestWrapper != null) {
                requestWrapper.setRedirected(false);
            }
        }
    }

    public void forward(PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException, IOException, IllegalStateException {
        CustomRequestWrapper requestWrapper = (CustomRequestWrapper)((HttpServletRequestWrapper)portletRequest).getRequest();
        CustomResponseWrapper servResponse = (CustomResponseWrapper)((PortletResponseImp)portletResponse).getResponse();
        NestedResponseWrapper responseWrapper = new NestedResponseWrapper((HttpServletResponse)servResponse);
        if (portletResponse instanceof MimeResponse && ((MimeResponse)portletResponse).isCommitted()) {
            throw new IllegalStateException("Can't forward on committed response");
        }
        try {
            requestWrapper.setRedirected(true);
            requestWrapper.setRedirectedPath(this.path);
            requestWrapper.setContextPath(portletRequest.getContextPath());
            if (portletRequest instanceof ActionRequest) {
                responseWrapper.setNoValues(true);
            } else if (portletRequest instanceof EventRequest) {
                requestWrapper.setNoInput(true);
                requestWrapper.setNoValues(true);
                responseWrapper.setNoValues(true);
            } else if (portletRequest instanceof ResourceRequest) {
                responseWrapper.setContentType(((ResourceResponse)portletResponse).getContentType());
            } else {
                responseWrapper.setContentType(null);
                requestWrapper.setNoInput(true);
                requestWrapper.setNoValues(true);
            }
            if (this.dispatcher != null) {
                this.dispatcher.forward((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
                byte[] ca = responseWrapper.getPortletContent();
                if (ca == null) {
                    ca = new byte[]{};
                }
                if (servResponse.isStreamUsed()) {
                    servResponse.getOutputStream().write(ca);
                } else {
                    servResponse.getWriter().write(new String(ca, "utf-8"));
                }
                ((PortletResponseImp)portletResponse).setAlreadyForwarded();
            }
        }
        catch (ServletException e) {
            if (e.getRootCause() != null) {
                this.log.error((Object)"Root cause of the exception", e.getRootCause());
            }
            this.log.error((Object)"Problems occur when using PortletDispatcher", (Throwable)e);
            throw new PortletException("Problems occur when using PortletDispatcher", (Throwable)e);
        }
    }
}

