/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.util.List;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletURL;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.BaseURLImp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletURLImp
extends BaseURLImp
implements PortletURL {
    protected List<Supports> supports;
    protected WindowState requiredWindowState;
    protected PortletMode requiredPortletMode;
    protected String markup;

    public PortletURLImp(String type, String baseURL, String markup, List<Supports> supports, boolean isCurrentlySecured, boolean defaultEscapeXml, Portlet portletDatas) {
        super(type, baseURL, isCurrentlySecured, defaultEscapeXml, portletDatas);
        this.markup = markup;
        this.supports = supports;
    }

    public final void setWindowState(WindowState windowState) throws WindowStateException {
        if (windowState == null) {
            throw new WindowStateException("The portlet state is null", windowState);
        }
        if (windowState == WindowState.NORMAL || windowState == WindowState.MINIMIZED || windowState == WindowState.MAXIMIZED) {
            this.requiredWindowState = windowState;
            return;
        }
        boolean supported = false;
        block0: for (Supports element : this.supports) {
            Supports sp = element;
            if (!this.markup.equals(sp.getMimeType())) continue;
            List stateList = sp.getWindowState();
            for (String stateString : stateList) {
                if (stateString == null || !stateString.equalsIgnoreCase(windowState.toString())) continue;
                supported = true;
                break block0;
            }
        }
        if (!supported) {
            throw new WindowStateException("The window state " + windowState.toString() + " is not supported by that portlet", windowState);
        }
        this.requiredWindowState = windowState;
    }

    public final void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (portletMode == null) {
            throw new PortletModeException("The portlet mode is null", portletMode);
        }
        if (portletMode == PortletMode.VIEW) {
            this.requiredPortletMode = portletMode;
            return;
        }
        boolean supported = false;
        block0: for (Supports element : this.supports) {
            Supports sp = element;
            if (!this.markup.equals(sp.getMimeType())) continue;
            List modeList = sp.getPortletMode();
            for (String modeString : modeList) {
                if (modeString == null || !modeString.equalsIgnoreCase(portletMode.toString())) continue;
                supported = true;
                break block0;
            }
        }
        if (!supported) {
            throw new PortletModeException("The mode " + portletMode.toString() + " is not supported by that portlet", portletMode);
        }
        this.requiredPortletMode = portletMode;
    }

    public final PortletMode getPortletMode() {
        return this.requiredPortletMode;
    }

    public final WindowState getWindowState() {
        return this.requiredWindowState;
    }

    protected final void invokeFilterRenderURL() {
        if (this.getPortletDatas() == null) {
            return;
        }
        List list = this.getPortletDatas().getApplication().getUrlListeners();
        if (list == null) {
            return;
        }
        for (PortletURLGenerationListener listener : list) {
            try {
                listener.filterRenderURL((PortletURL)this);
            }
            catch (Exception e) {}
        }
    }

    protected final void invokeFilterActionURL() {
        if (this.getPortletDatas() == null) {
            return;
        }
        List list = this.getPortletDatas().getApplication().getUrlListeners();
        if (list == null) {
            return;
        }
        for (PortletURLGenerationListener listener : list) {
            try {
                listener.filterActionURL((PortletURL)this);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public String toString(boolean escapeXML) {
        if (this.getType().equals("action")) {
            this.invokeFilterActionURL();
        } else {
            this.invokeFilterRenderURL();
        }
        if (!this.isSetSecureCalled() && this.isCurrentlySecured()) {
            this.setSecure(true);
        }
        StringBuffer sB = new StringBuffer();
        sB.append(this.baseURL);
        sB.append("&");
        sB.append("portal:type");
        sB.append("=");
        sB.append(this.getType());
        sB.append("&");
        sB.append("portal:isSecure");
        sB.append("=");
        sB.append(this.isSecure());
        if (this.requiredPortletMode != null) {
            sB.append("&");
            sB.append("portal:portletMode");
            sB.append("=");
            sB.append(this.requiredPortletMode);
        }
        if (this.requiredWindowState != null) {
            sB.append("&");
            sB.append("portal:windowState");
            sB.append("=");
            sB.append(this.requiredWindowState);
        }
        Set names = this.parameters.keySet();
        for (String name : names) {
            String[] values;
            Object obj = this.parameters.get(name);
            if (obj instanceof String) {
                String value = (String)obj;
                sB.append("&");
                sB.append(this.encode(name));
                sB.append("=");
                sB.append(this.encode(value));
                continue;
            }
            for (String element : values = (String[])obj) {
                sB.append("&");
                sB.append(this.encode(name));
                sB.append("=");
                sB.append(this.encode(element));
            }
        }
        String propertyString = this.getPropertyString();
        if (propertyString != "" && propertyString != null) {
            sB.append(propertyString);
        }
        if (escapeXML) {
            return this.encodeChars(sB.toString());
        }
        return sB.toString();
    }

    public final void removePublicRenderParameter(String name) {
        this.setParameter("portal:removePublicParam", name);
    }
}

