/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcontainer.helper.URLEncoder;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.CustomResponseWrapper;

public class NestedResponseWrapper
extends HttpServletResponseWrapper {
    private String contentType = "";
    private final PrintWriter tmpWriter;
    private final ProxyServletOutputStream output;
    private boolean noOutput;
    private boolean noValues;
    private URLEncoder urlEncoder;
    private final CharArrayWriter charArrayWriter = new CharArrayWriter();
    private boolean writerAlreadyCalled = false;
    private boolean outputStreamAlreadyCalled = false;
    private static Log log = ExoLogger.getLogger(CustomResponseWrapper.class);
    private boolean committed = false;

    public NestedResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.tmpWriter = new PrintWriter(this.charArrayWriter){

            public boolean equals(Object obj) {
                return true;
            }

            public void close() {
                log.debug((Object)"try to close");
            }
        };
        this.output = new ProxyServletOutputStream(this.tmpWriter);
    }

    public final String getContentType() {
        if (this.noValues) {
            return null;
        }
        return this.contentType;
    }

    public final void setContentType(String type) {
        super.setContentType(type);
        this.contentType = type;
    }

    public final void finalize() throws Throwable {
        super.finalize();
        this.output.close();
        this.tmpWriter.close();
    }

    public final byte[] getPortletContent() {
        if (this.outputStreamAlreadyCalled || this.writerAlreadyCalled) {
            try {
                return new String(this.charArrayWriter.toCharArray()).getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.charArrayWriter.toCharArray()).getBytes();
            }
        }
        return null;
    }

    public final PrintWriter getWriter() throws IOException {
        if (this.noOutput) {
            return null;
        }
        this.writerAlreadyCalled = true;
        log.debug((Object)"getWriter()");
        return this.tmpWriter;
    }

    public final ServletOutputStream getOutputStream() throws IOException {
        if (this.noOutput) {
            return null;
        }
        log.debug((Object)"getOutputStream()");
        this.outputStreamAlreadyCalled = true;
        return this.output;
    }

    public final byte[] toByteArray() {
        try {
            return new String(this.charArrayWriter.toCharArray()).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.charArrayWriter.toCharArray()).getBytes();
        }
    }

    public final void flushBuffer() throws IOException {
        log.debug((Object)"flushBuffer()");
        this.tmpWriter.flush();
    }

    public final void reset() {
        log.debug((Object)"reset()");
        this.charArrayWriter.reset();
    }

    public final void close() throws IOException {
        log.debug((Object)"close()");
    }

    public final int getBufferSize() {
        log.debug((Object)"getBufferSize()");
        return 0;
    }

    public final String encodeURL(String url) {
        if (this.urlEncoder == null) {
            return super.encodeURL(url);
        }
        return this.urlEncoder.encodeURL(url);
    }

    public final void setURLEncoder(URLEncoder encoder) {
        this.urlEncoder = encoder;
    }

    public final void sendRedirect(String location) throws IOException {
        log.debug((Object)("Send redirect [" + location + "]"));
        super.sendRedirect(location);
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) || this.getResponse().equals(obj);
    }

    public final String encodeRedirectURL(String url) {
        if (url != null) {
            return super.encodeRedirectURL(url);
        }
        return null;
    }

    public final String encodeRedirectUrl(String url) {
        if (url != null) {
            return super.encodeRedirectUrl(url);
        }
        return null;
    }

    public final boolean isCommitted() {
        return this.committed;
    }

    public final void setCommitted() {
        this.committed = true;
    }

    public final boolean isNoOutput() {
        return this.noOutput;
    }

    public final void setNoOutput(boolean noOutput) {
        this.noOutput = noOutput;
    }

    public final String getCharacterEncoding() {
        if (this.noValues) {
            return null;
        }
        return super.getCharacterEncoding();
    }

    public final Locale getLocale() {
        if (this.noValues) {
            return null;
        }
        return super.getLocale();
    }

    public final void setNoValues(boolean noValues) {
        this.noValues = noValues;
    }

    private static class ProxyServletOutputStream
    extends ServletOutputStream {
        private final PrintWriter writer;

        public ProxyServletOutputStream(PrintWriter writer) {
            this.writer = writer;
        }

        public final void write(int i) throws IOException {
            this.writer.write(i);
        }
    }
}

